/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.MultiInputStream;
import com.google.common.io.ParametricNullness;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ByteSource {
    protected ByteSource() {
    }

    /*
     * WARNING - void declaration
     */
    public CharSource asCharSource(Charset charset) {
        void var1_1;
        return new AsCharSource(this, (Charset)var1_1);
    }

    public abstract InputStream openStream() throws IOException;

    /*
     * WARNING - void declaration
     */
    public InputStream openBufferedStream() throws IOException {
        void var1_1;
        InputStream in = this.openStream();
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream((InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ByteSource slice(long offset, long length) {
        void var3_2;
        void var1_1;
        return new SlicedByteSource((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty() throws IOException {
        boolean bl;
        Optional<Long> sizeIfKnown = this.sizeIfKnown();
        if (sizeIfKnown.isPresent()) {
            return sizeIfKnown.get() == 0L;
        }
        Closer closer = Closer.create();
        try {
            InputStream inputStream = closer.register(this.openStream());
            bl = inputStream.read() == -1;
        }
        catch (Throwable e) {
            try {
                void var2_4;
                throw closer.rethrow((Throwable)var2_4);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return bl;
    }

    @Beta
    public Optional<Long> sizeIfKnown() {
        return Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    public long size() throws IOException {
        long l;
        Optional<Long> sizeIfKnown = this.sizeIfKnown();
        if (sizeIfKnown.isPresent()) {
            return sizeIfKnown.get();
        }
        try (Closer closer = Closer.create();){
            InputStream in = closer.register(this.openStream());
            long l2 = this.countBySkipping(in);
            return l2;
        }
        closer = Closer.create();
        try {
            InputStream in = closer.register(this.openStream());
            l = ByteStreams.exhaust(in);
        }
        catch (Throwable e) {
            try {
                void var2_5;
                throw closer.rethrow((Throwable)var2_5);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private long countBySkipping(InputStream in) throws IOException {
        void var2_2;
        long skipped;
        long count = 0L;
        while ((skipped = ByteStreams.skipUpTo(in, Integer.MAX_VALUE)) > 0L) {
            count += skipped;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long copyTo(OutputStream output) throws IOException {
        long l;
        Preconditions.checkNotNull(output);
        Closer closer = Closer.create();
        try {
            void var1_1;
            InputStream inputStream = closer.register(this.openStream());
            l = ByteStreams.copy(inputStream, (OutputStream)var1_1);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long copyTo(ByteSink sink) throws IOException {
        long l;
        Preconditions.checkNotNull(sink);
        Closer closer = Closer.create();
        try {
            void var1_1;
            InputStream in = closer.register(this.openStream());
            OutputStream out = closer.register(sink.openStream());
            l = ByteStreams.copy(in, (OutputStream)var1_1);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] read() throws IOException {
        Object in;
        Closer closer = Closer.create();
        try {
            void var3_5;
            in = closer.register(this.openStream());
            Optional<Long> size = this.sizeIfKnown();
            in = size.isPresent() ? ByteStreams.toByteArray((InputStream)in, (Long)var3_5.get()) : ByteStreams.toByteArray((InputStream)in);
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return in;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public <T> T read(ByteProcessor<T> processor) throws IOException {
        Object t;
        Preconditions.checkNotNull(processor);
        Closer closer = Closer.create();
        try {
            InputStream inputStream = closer.register(this.openStream());
            t = ByteStreams.readBytes(inputStream, t);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public HashCode hash(HashFunction hashFunction) throws IOException {
        void var1_1;
        Hasher hasher = hashFunction.newHasher();
        this.copyTo(Funnels.asOutputStream(hasher));
        return var1_1.hash();
    }

    public boolean contentEquals(ByteSource other) throws IOException {
        Preconditions.checkNotNull(other);
        byte[] buf1 = ByteStreams.createBuffer();
        byte[] buf2 = ByteStreams.createBuffer();
        try (Closer closer = Closer.create();){
            InputStream in1 = closer.register(this.openStream());
            InputStream in2 = closer.register(other.openStream());
            while (true) {
                int read2;
                int read1;
                if ((read1 = ByteStreams.read(in1, buf1, 0, buf1.length)) != (read2 = ByteStreams.read(in2, buf2, 0, buf2.length)) || !Arrays.equals(buf1, buf2)) {
                    return false;
                }
                if (read1 == buf1.length) continue;
                return true;
            }
        }
    }

    public static ByteSource concat(Iterable<? extends ByteSource> sources) {
        Iterable<? extends ByteSource> iterable;
        return new ConcatenatedByteSource(iterable);
    }

    public static ByteSource concat(Iterator<? extends ByteSource> sources) {
        return ByteSource.concat(ImmutableList.copyOf(sources));
    }

    public static ByteSource concat(ByteSource ... sources) {
        return ByteSource.concat(ImmutableList.copyOf(sources));
    }

    public static ByteSource wrap(byte[] b) {
        byte[] byArray;
        return new ByteArrayByteSource(byArray);
    }

    public static ByteSource empty() {
        return EmptyByteSource.INSTANCE;
    }

    private static final class ConcatenatedByteSource
    extends ByteSource {
        final Iterable<? extends ByteSource> sources;

        /*
         * WARNING - void declaration
         */
        ConcatenatedByteSource(Iterable<? extends ByteSource> sources) {
            void var1_1;
            this.sources = (Iterable)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final InputStream openStream() throws IOException {
            return new MultiInputStream(this.sources.iterator());
        }

        @Override
        public final boolean isEmpty() throws IOException {
            for (ByteSource byteSource : this.sources) {
                if (byteSource.isEmpty()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<Long> sizeIfKnown() {
            void var1_1;
            if (!(this.sources instanceof Collection)) {
                return Optional.absent();
            }
            long result = 0L;
            for (ByteSource byteSource : this.sources) {
                Optional<Long> byteSource2 = byteSource.sizeIfKnown();
                if (!byteSource2.isPresent()) {
                    return Optional.absent();
                }
                if ((result += byteSource2.get().longValue()) >= 0L) continue;
                return Optional.of(Long.MAX_VALUE);
            }
            return Optional.of((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long size() throws IOException {
            void var1_1;
            long result = 0L;
            for (ByteSource byteSource : this.sources) {
                if ((result += byteSource.size()) >= 0L) continue;
                return Long.MAX_VALUE;
            }
            return (long)var1_1;
        }

        public final String toString() {
            String string = String.valueOf(this.sources);
            return new StringBuilder(19 + String.valueOf(string).length()).append("ByteSource.concat(").append(string).append(")").toString();
        }
    }

    private static final class EmptyByteSource
    extends ByteArrayByteSource {
        static final EmptyByteSource INSTANCE = new EmptyByteSource();

        EmptyByteSource() {
            super(new byte[0]);
        }

        @Override
        public final CharSource asCharSource(Charset charset) {
            Preconditions.checkNotNull(charset);
            return CharSource.empty();
        }

        @Override
        public final byte[] read() {
            return this.bytes;
        }

        @Override
        public final String toString() {
            return "ByteSource.empty()";
        }
    }

    private static class ByteArrayByteSource
    extends ByteSource {
        final byte[] bytes;
        final int offset;
        final int length;

        /*
         * WARNING - void declaration
         */
        ByteArrayByteSource(byte[] bytes) {
            this(bytes, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ByteArrayByteSource(byte[] bytes, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.bytes = var1_1;
            this.offset = var2_2;
            this.length = var3_3;
        }

        @Override
        public InputStream openStream() {
            return new ByteArrayInputStream(this.bytes, this.offset, this.length);
        }

        @Override
        public InputStream openBufferedStream() throws IOException {
            return ((ByteSource)this).openStream();
        }

        @Override
        public boolean isEmpty() {
            return this.length == 0;
        }

        @Override
        public long size() {
            return this.length;
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            return Optional.of(Long.valueOf(this.length));
        }

        @Override
        public byte[] read() {
            return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public <T> T read(ByteProcessor<T> processor) throws IOException {
            void var1_1;
            processor.processBytes(this.bytes, this.offset, this.length);
            return var1_1.getResult();
        }

        @Override
        public long copyTo(OutputStream output) throws IOException {
            output.write(this.bytes, this.offset, this.length);
            return this.length;
        }

        @Override
        public HashCode hash(HashFunction hashFunction) throws IOException {
            return hashFunction.hashBytes(this.bytes, this.offset, this.length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteSource slice(long offset, long length) {
            void var3_3;
            void var1_2;
            Preconditions.checkArgument(offset >= 0L, "offset (%s) may not be negative", offset);
            Preconditions.checkArgument(length >= 0L, "length (%s) may not be negative", length);
            offset = Math.min(offset, (long)this.length);
            length = Math.min(length, (long)this.length - offset);
            int newOffset = this.offset + (int)offset;
            return new ByteArrayByteSource(this.bytes, (int)var1_2, (int)var3_3);
        }

        public String toString() {
            String string = Ascii.truncate(BaseEncoding.base16().encode(this.bytes, this.offset, this.length), 30, "...");
            return new StringBuilder(17 + String.valueOf(string).length()).append("ByteSource.wrap(").append(string).append(")").toString();
        }
    }

    private final class SlicedByteSource
    extends ByteSource {
        final long offset;
        final long length;

        /*
         * WARNING - void declaration
         */
        SlicedByteSource(long offset, long length) {
            void var2_2;
            Preconditions.checkArgument(offset >= 0L, "offset (%s) may not be negative", offset);
            Preconditions.checkArgument(length >= 0L, "length (%s) may not be negative", length);
            this.offset = var2_2;
            this.length = length;
        }

        @Override
        public final InputStream openStream() throws IOException {
            SlicedByteSource slicedByteSource = this;
            return slicedByteSource.sliceStream(slicedByteSource.ByteSource.this.openStream());
        }

        @Override
        public final InputStream openBufferedStream() throws IOException {
            SlicedByteSource slicedByteSource = this;
            return slicedByteSource.sliceStream(slicedByteSource.ByteSource.this.openBufferedStream());
        }

        /*
         * WARNING - void declaration
         */
        private InputStream sliceStream(InputStream in2) throws IOException {
            void var1_1;
            if (this.offset > 0L) {
                void var2_3;
                try {
                    long skipped = ByteStreams.skipUpTo(in2, this.offset);
                }
                catch (Throwable e) {
                    Closer closer = Closer.create();
                    closer.register(in2);
                    try {
                        throw closer.rethrow(e);
                    }
                    catch (Throwable in2) {
                        void var3_5;
                        var3_5.close();
                        throw in2;
                    }
                }
                if (var2_3 < this.offset) {
                    InputStream in2;
                    in2.close();
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
            return ByteStreams.limit((InputStream)var1_1, this.length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteSource slice(long offset, long length) {
            void var3_2;
            void var1_1;
            Preconditions.checkArgument(offset >= 0L, "offset (%s) may not be negative", offset);
            Preconditions.checkArgument(length >= 0L, "length (%s) may not be negative", length);
            long maxLength = this.length - offset;
            if (maxLength <= 0L) {
                return ByteSource.empty();
            }
            return ByteSource.this.slice(this.offset + var1_1, Math.min((long)var3_2, maxLength));
        }

        @Override
        public final boolean isEmpty() throws IOException {
            return this.length == 0L || super.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<Long> sizeIfKnown() {
            Optional<Long> optionalUnslicedSize = ByteSource.this.sizeIfKnown();
            if (optionalUnslicedSize.isPresent()) {
                void var2_2;
                void var1_1;
                long unslicedSize = (Long)var1_1.get();
                long off = Math.min(this.offset, unslicedSize);
                return Optional.of(Math.min(this.length, (long)(var2_2 - off)));
            }
            return Optional.absent();
        }

        public final String toString() {
            String string = ByteSource.this.toString();
            long l = this.offset;
            long l2 = this.length;
            return new StringBuilder(50 + String.valueOf(string).length()).append(string).append(".slice(").append(l).append(", ").append(l2).append(")").toString();
        }
    }

    class AsCharSource
    extends CharSource {
        final Charset charset;
        final /* synthetic */ ByteSource this$0;

        /*
         * WARNING - void declaration
         */
        AsCharSource(ByteSource this$0, Charset charset) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.charset = (Charset)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteSource asByteSource(Charset charset) {
            void var1_1;
            if (charset.equals(this.charset)) {
                return this.this$0;
            }
            return super.asByteSource((Charset)var1_1);
        }

        @Override
        public Reader openStream() throws IOException {
            return new InputStreamReader(this.this$0.openStream(), this.charset);
        }

        @Override
        public String read() throws IOException {
            return new String(this.this$0.read(), this.charset);
        }

        public String toString() {
            String string = this.this$0.toString();
            String string2 = String.valueOf(this.charset);
            return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".asCharSource(").append(string2).append(")").toString();
        }
    }
}

