/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ByteSink {
    protected ByteSink() {
    }

    /*
     * WARNING - void declaration
     */
    public CharSink asCharSink(Charset charset) {
        void var1_1;
        return new AsCharSink((Charset)var1_1);
    }

    public abstract OutputStream openStream() throws IOException;

    /*
     * WARNING - void declaration
     */
    public OutputStream openBufferedStream() throws IOException {
        void var1_1;
        OutputStream out = this.openStream();
        if (out instanceof BufferedOutputStream) {
            return (BufferedOutputStream)out;
        }
        return new BufferedOutputStream((OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write(byte[] bytes) throws IOException {
        Preconditions.checkNotNull(bytes);
        Closer closer = Closer.create();
        try {
            void var1_1;
            OutputStream out = closer.register(this.openStream());
            out.write((byte[])var1_1);
            out.flush();
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public long writeFrom(InputStream input) throws IOException {
        long l;
        Preconditions.checkNotNull(input);
        Closer closer = Closer.create();
        try {
            void var1_1;
            OutputStream out = closer.register(this.openStream());
            long written = ByteStreams.copy((InputStream)var1_1, out);
            out.flush();
            l = written;
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    private final class AsCharSink
    extends CharSink {
        private final Charset charset;

        /*
         * WARNING - void declaration
         */
        private AsCharSink(Charset charset) {
            void var2_2;
            this.charset = (Charset)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public final Writer openStream() throws IOException {
            return new OutputStreamWriter(ByteSink.this.openStream(), this.charset);
        }

        public final String toString() {
            String string = ByteSink.this.toString();
            String string2 = String.valueOf(this.charset);
            return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".asCharSink(").append(string2).append(")").toString();
        }
    }
}

