/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.RoundingMode;
import java.util.Arrays;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class BaseEncoding {
    private static final BaseEncoding BASE64 = new Base64Encoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", Character.valueOf('='));
    private static final BaseEncoding BASE64_URL = new Base64Encoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", Character.valueOf('='));
    private static final BaseEncoding BASE32 = new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
    private static final BaseEncoding BASE32_HEX = new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
    private static final BaseEncoding BASE16 = new Base16Encoding("base16()", "0123456789ABCDEF");

    BaseEncoding() {
    }

    /*
     * WARNING - void declaration
     */
    public String encode(byte[] bytes) {
        void var1_1;
        return this.encode(bytes, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(byte[] bytes, int off, int len) {
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, bytes.length);
        StringBuilder result = new StringBuilder(this.maxEncodedSize(len));
        try {
            void var3_4;
            void var2_3;
            this.encodeTo(result, bytes, (int)var2_3, (int)var3_4);
        }
        catch (IOException impossible) {
            void var1_2;
            throw new AssertionError(var1_2);
        }
        return result.toString();
    }

    @GwtIncompatible
    public abstract OutputStream encodingStream(Writer var1);

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final ByteSink encodingSink(CharSink encodedSink) {
        void var1_1;
        Preconditions.checkNotNull(encodedSink);
        return new ByteSink(this, (CharSink)var1_1){
            final /* synthetic */ CharSink val$encodedSink;
            final /* synthetic */ BaseEncoding this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$encodedSink = charSink;
            }

            @Override
            public OutputStream openStream() throws IOException {
                return this.this$0.encodingStream(this.val$encodedSink.openStream());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] extract(byte[] result, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (length == result.length) {
            return result;
        }
        byte[] trunc = new byte[length];
        System.arraycopy(byArray, 0, trunc, 0, (int)var1_1);
        return var2_2;
    }

    public abstract boolean canDecode(CharSequence var1);

    /*
     * WARNING - void declaration
     */
    public final byte[] decode(CharSequence chars) {
        try {
            return this.decodeChecked(chars);
        }
        catch (DecodingException badInput) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final byte[] decodeChecked(CharSequence chars) throws DecodingException {
        void var1_2;
        void var2_3;
        chars = this.trimTrailingPadding(chars);
        byte[] tmp = new byte[this.maxDecodedSize(chars.length())];
        int len = this.decodeTo(tmp, chars);
        return BaseEncoding.extract((byte[])var2_3, (int)var1_2);
    }

    @GwtIncompatible
    public abstract InputStream decodingStream(Reader var1);

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final ByteSource decodingSource(CharSource encodedSource) {
        void var1_1;
        Preconditions.checkNotNull(encodedSource);
        return new ByteSource(this, (CharSource)var1_1){
            final /* synthetic */ CharSource val$encodedSource;
            final /* synthetic */ BaseEncoding this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$encodedSource = charSource;
            }

            @Override
            public InputStream openStream() throws IOException {
                return this.this$0.decodingStream(this.val$encodedSource.openStream());
            }
        };
    }

    abstract int maxEncodedSize(int var1);

    abstract void encodeTo(Appendable var1, byte[] var2, int var3, int var4) throws IOException;

    abstract int maxDecodedSize(int var1);

    abstract int decodeTo(byte[] var1, CharSequence var2) throws DecodingException;

    CharSequence trimTrailingPadding(CharSequence chars) {
        return Preconditions.checkNotNull(chars);
    }

    public abstract BaseEncoding omitPadding();

    public abstract BaseEncoding withPadChar(char var1);

    public abstract BaseEncoding withSeparator(String var1, int var2);

    public abstract BaseEncoding upperCase();

    public abstract BaseEncoding lowerCase();

    public static BaseEncoding base64() {
        return BASE64;
    }

    public static BaseEncoding base64Url() {
        return BASE64_URL;
    }

    public static BaseEncoding base32() {
        return BASE32;
    }

    public static BaseEncoding base32Hex() {
        return BASE32_HEX;
    }

    public static BaseEncoding base16() {
        return BASE16;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static Reader ignoringReader(Reader delegate, String toIgnore) {
        void var1_1;
        Reader reader;
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(toIgnore);
        return new Reader((String)var1_1){
            final /* synthetic */ String val$toIgnore;
            {
                this.val$toIgnore = string;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int read() throws IOException {
                void var1_1;
                int readChar;
                while ((readChar = reader.read()) != -1 && this.val$toIgnore.indexOf((char)readChar) >= 0) {
                }
                return (int)var1_1;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static Appendable separatingAppendable(Appendable delegate, String separator, int afterEveryChars) {
        void var1_1;
        Appendable appendable;
        void var2_2;
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(separator);
        Preconditions.checkArgument(afterEveryChars > 0);
        return new Appendable((int)var2_2, appendable, (String)var1_1){
            int charsUntilSeparator;
            final /* synthetic */ int val$afterEveryChars;
            final /* synthetic */ Appendable val$delegate;
            final /* synthetic */ String val$separator;
            {
                this.val$afterEveryChars = n;
                this.val$delegate = appendable;
                this.val$separator = string;
                this.charsUntilSeparator = this.val$afterEveryChars;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Appendable append(char c) throws IOException {
                void var1_1;
                if (this.charsUntilSeparator == 0) {
                    this.val$delegate.append(this.val$separator);
                    this.charsUntilSeparator = this.val$afterEveryChars;
                }
                this.val$delegate.append((char)var1_1);
                --this.charsUntilSeparator;
                return this;
            }

            @Override
            public Appendable append(CharSequence chars, int off, int len) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Appendable append(CharSequence chars) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static Writer separatingWriter(Writer delegate, String separator, int afterEveryChars) {
        Writer writer;
        void var1_1;
        void var2_2;
        Appendable separatingAppendable = BaseEncoding.separatingAppendable(delegate, separator, (int)var2_2);
        return new Writer((Appendable)var1_1, writer){
            final /* synthetic */ Appendable val$separatingAppendable;
            final /* synthetic */ Writer val$delegate;
            {
                this.val$separatingAppendable = appendable;
                this.val$delegate = writer;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(int c) throws IOException {
                void var1_1;
                this.val$separatingAppendable.append((char)var1_1);
            }

            @Override
            public void write(char[] chars, int off, int len) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void flush() throws IOException {
                this.val$delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.val$delegate.close();
            }
        };
    }

    static final class SeparatedBaseEncoding
    extends BaseEncoding {
        private final BaseEncoding delegate;
        private final String separator;
        private final int afterEveryChars;

        /*
         * WARNING - void declaration
         */
        SeparatedBaseEncoding(BaseEncoding delegate, String separator, int afterEveryChars) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.delegate = (BaseEncoding)Preconditions.checkNotNull(var1_1);
            this.separator = (String)Preconditions.checkNotNull(var2_2);
            this.afterEveryChars = afterEveryChars;
            Preconditions.checkArgument(afterEveryChars > 0, "Cannot add a separator after every %s chars", (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final CharSequence trimTrailingPadding(CharSequence chars) {
            void var1_1;
            return this.delegate.trimTrailingPadding((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int maxEncodedSize(int bytes) {
            void var1_1;
            int unseparatedSize = this.delegate.maxEncodedSize(bytes);
            return unseparatedSize + this.separator.length() * IntMath.divide(Math.max(0, (int)(var1_1 - true)), this.afterEveryChars, RoundingMode.FLOOR);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        public final OutputStream encodingStream(Writer output) {
            void var1_1;
            return this.delegate.encodingStream(SeparatedBaseEncoding.separatingWriter((Writer)var1_1, this.separator, this.afterEveryChars));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void encodeTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.delegate.encodeTo(SeparatedBaseEncoding.separatingAppendable((Appendable)var1_1, this.separator, this.afterEveryChars), (byte[])var2_2, (int)var3_3, len);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int maxDecodedSize(int chars) {
            void var1_1;
            return this.delegate.maxDecodedSize((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean canDecode(CharSequence chars) {
            void var2_2;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                if (this.separator.indexOf(c) >= 0) continue;
                builder.append(c);
            }
            return this.delegate.canDecode((CharSequence)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int decodeTo(byte[] target, CharSequence chars) throws DecodingException {
            void var3_3;
            void var1_1;
            StringBuilder stripped = new StringBuilder(chars.length());
            for (int i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                if (this.separator.indexOf(c) >= 0) continue;
                stripped.append(c);
            }
            return this.delegate.decodeTo((byte[])var1_1, (CharSequence)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        public final InputStream decodingStream(Reader reader) {
            void var1_1;
            return this.delegate.decodingStream(SeparatedBaseEncoding.ignoringReader((Reader)var1_1, this.separator));
        }

        @Override
        public final BaseEncoding omitPadding() {
            return this.delegate.omitPadding().withSeparator(this.separator, this.afterEveryChars);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final BaseEncoding withPadChar(char padChar) {
            void var1_1;
            return this.delegate.withPadChar((char)var1_1).withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public final BaseEncoding withSeparator(String separator, int afterEveryChars) {
            throw new UnsupportedOperationException("Already have a separator");
        }

        @Override
        public final BaseEncoding upperCase() {
            return this.delegate.upperCase().withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public final BaseEncoding lowerCase() {
            return this.delegate.lowerCase().withSeparator(this.separator, this.afterEveryChars);
        }

        public final String toString() {
            String string = String.valueOf(this.delegate);
            String string2 = this.separator;
            int n = this.afterEveryChars;
            return new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".withSeparator(\"").append(string2).append("\", ").append(n).append(")").toString();
        }
    }

    static final class Base64Encoding
    extends StandardBaseEncoding {
        /*
         * WARNING - void declaration
         */
        Base64Encoding(String name, String alphabetChars, Character paddingChar) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()), (Character)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Base64Encoding(Alphabet alphabet, Character paddingChar) {
            super(alphabet, (Character)var2_2);
            void var1_1;
            void var2_2;
            Preconditions.checkArgument(((Alphabet)var1_1).chars.length == 64);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void encodeTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
            Preconditions.checkNotNull(target);
            int n = off;
            Preconditions.checkPositionIndexes(n, n + len, bytes.length);
            int i = off;
            for (int remaining = len; remaining >= 3; remaining -= 3) {
                int chunk = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
                target.append(this.alphabet.encode(chunk >>> 18));
                target.append(this.alphabet.encode(chunk >>> 12 & 0x3F));
                target.append(this.alphabet.encode(chunk >>> 6 & 0x3F));
                target.append(this.alphabet.encode(chunk & 0x3F));
            }
            if (i < off + len) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.encodeChunkTo((Appendable)var1_1, (byte[])var2_2, i, (int)(var3_3 + len - i));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int decodeTo(byte[] target, CharSequence chars) throws DecodingException {
            void var3_4;
            Preconditions.checkNotNull(target);
            chars = this.trimTrailingPadding(chars);
            if (!this.alphabet.isValidPaddingStartPosition(chars.length())) {
                int n = chars.length();
                throw new DecodingException(new StringBuilder(32).append("Invalid input length ").append(n).toString());
            }
            int bytesWritten = 0;
            int i = 0;
            while (i < chars.length()) {
                int n = this.alphabet.decode(chars.charAt(i++)) << 18;
                int chunk = n | this.alphabet.decode(chars.charAt(i++)) << 12;
                target[bytesWritten++] = (byte)(chunk >>> 16);
                if (i >= chars.length()) continue;
                target[bytesWritten++] = (byte)((chunk |= this.alphabet.decode(chars.charAt(i++)) << 6) >>> 8);
                if (i >= chars.length()) continue;
                target[bytesWritten++] = (byte)(chunk |= this.alphabet.decode(chars.charAt(i++)));
            }
            return (int)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final BaseEncoding newInstance(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            return new Base64Encoding((Alphabet)var1_1, (Character)var2_2);
        }
    }

    static final class Base16Encoding
    extends StandardBaseEncoding {
        final char[] encoding = new char[512];

        /*
         * WARNING - void declaration
         */
        Base16Encoding(String name, String alphabetChars) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()));
            void var2_2;
            void var1_1;
        }

        private Base16Encoding(Alphabet alphabet) {
            super(alphabet, null);
            Preconditions.checkArgument(alphabet.chars.length == 16);
            for (int i = 0; i < 256; ++i) {
                this.encoding[i] = alphabet.encode(i >>> 4);
                this.encoding[i | 0x100] = alphabet.encode(i & 0xF);
            }
        }

        @Override
        final void encodeTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
            Preconditions.checkNotNull(target);
            int n = off;
            Preconditions.checkPositionIndexes(n, n + len, bytes.length);
            for (int i = 0; i < len; ++i) {
                int b = bytes[off + i] & 0xFF;
                target.append(this.encoding[b]);
                target.append(this.encoding[b | 0x100]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int decodeTo(byte[] target, CharSequence chars) throws DecodingException {
            void var3_4;
            Preconditions.checkNotNull(target);
            if (chars.length() % 2 == 1) {
                int n = chars.length();
                throw new DecodingException(new StringBuilder(32).append("Invalid input length ").append(n).toString());
            }
            int bytesWritten = 0;
            for (int i = 0; i < chars.length(); i += 2) {
                int decoded = this.alphabet.decode(chars.charAt(i)) << 4 | this.alphabet.decode(chars.charAt(i + 1));
                target[bytesWritten++] = (byte)decoded;
            }
            return (int)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final BaseEncoding newInstance(Alphabet alphabet, Character paddingChar) {
            void var1_1;
            return new Base16Encoding((Alphabet)var1_1);
        }
    }

    static class StandardBaseEncoding
    extends BaseEncoding {
        final Alphabet alphabet;
        final Character paddingChar;
        private transient BaseEncoding upperCase;
        private transient BaseEncoding lowerCase;

        /*
         * WARNING - void declaration
         */
        StandardBaseEncoding(String name, String alphabetChars, Character paddingChar) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()), (Character)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        StandardBaseEncoding(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            this.alphabet = Preconditions.checkNotNull(alphabet);
            Preconditions.checkArgument(paddingChar == null || !var1_1.matches(paddingChar.charValue()), "Padding character %s was already in alphabet", (Object)paddingChar);
            this.paddingChar = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int maxEncodedSize(int bytes) {
            void var1_1;
            return this.alphabet.charsPerChunk * IntMath.divide((int)var1_1, this.alphabet.bytesPerChunk, RoundingMode.CEILING);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        public OutputStream encodingStream(Writer out) {
            void var1_1;
            Preconditions.checkNotNull(out);
            return new OutputStream(this, (Writer)var1_1){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                int writtenChars = 0;
                final /* synthetic */ Writer val$out;
                final /* synthetic */ StandardBaseEncoding this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$out = writer;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void write(int b) throws IOException {
                    this.bitBuffer <<= 8;
                    this.bitBuffer |= b & 0xFF;
                    this.bitBufferLength += 8;
                    while (this.bitBufferLength >= this.this$0.alphabet.bitsPerChar) {
                        void var1_1;
                        int charIndex = this.bitBuffer >> this.bitBufferLength - this.this$0.alphabet.bitsPerChar & this.this$0.alphabet.mask;
                        this.val$out.write(this.this$0.alphabet.encode((int)var1_1));
                        ++this.writtenChars;
                        this.bitBufferLength -= this.this$0.alphabet.bitsPerChar;
                    }
                }

                @Override
                public void flush() throws IOException {
                    this.val$out.flush();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void close() throws IOException {
                    if (this.bitBufferLength > 0) {
                        void var1_1;
                        int charIndex = this.bitBuffer << this.this$0.alphabet.bitsPerChar - this.bitBufferLength & this.this$0.alphabet.mask;
                        this.val$out.write(this.this$0.alphabet.encode((int)var1_1));
                        ++this.writtenChars;
                        if (this.this$0.paddingChar != null) {
                            while (this.writtenChars % this.this$0.alphabet.charsPerChunk != 0) {
                                this.val$out.write(this.this$0.paddingChar.charValue());
                                ++this.writtenChars;
                            }
                        }
                    }
                    this.val$out.close();
                }
            };
        }

        @Override
        void encodeTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
            Preconditions.checkNotNull(target);
            int n = off;
            Preconditions.checkPositionIndexes(n, n + len, bytes.length);
            for (int i = 0; i < len; i += this.alphabet.bytesPerChunk) {
                this.encodeChunkTo(target, bytes, off + i, Math.min(this.alphabet.bytesPerChunk, len - i));
            }
        }

        /*
         * WARNING - void declaration
         */
        void encodeChunkTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
            int bitsProcessed;
            Preconditions.checkNotNull(target);
            int n = off;
            Preconditions.checkPositionIndexes(n, n + len, bytes.length);
            Preconditions.checkArgument(len <= this.alphabet.bytesPerChunk);
            long bitBuffer = 0L;
            for (int i = 0; i < len; ++i) {
                bitBuffer |= (long)(bytes[off + i] & 0xFF);
                bitBuffer <<= 8;
            }
            int bitOffset = (len + 1 << 3) - this.alphabet.bitsPerChar;
            for (bitsProcessed = 0; bitsProcessed < len << 3; bitsProcessed += this.alphabet.bitsPerChar) {
                void var3_4;
                int charIndex = (int)(bitBuffer >>> bitOffset - bitsProcessed) & this.alphabet.mask;
                target.append(this.alphabet.encode((int)var3_4));
            }
            if (this.paddingChar != null) {
                while (bitsProcessed < this.alphabet.bytesPerChunk << 3) {
                    target.append(this.paddingChar.charValue());
                    bitsProcessed += this.alphabet.bitsPerChar;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int maxDecodedSize(int chars) {
            void var1_1;
            return (int)(((long)this.alphabet.bitsPerChar * (long)var1_1 + 7L) / 8L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        CharSequence trimTrailingPadding(CharSequence chars) {
            void var3_3;
            void var1_1;
            Preconditions.checkNotNull(chars);
            if (this.paddingChar == null) {
                return chars;
            }
            char padChar = this.paddingChar.charValue();
            for (int l = chars.length() - 1; l >= 0 && chars.charAt(l) == padChar; --l) {
            }
            return var1_1.subSequence(0, (int)(var3_3 + true));
        }

        @Override
        public boolean canDecode(CharSequence chars) {
            Preconditions.checkNotNull(chars);
            chars = this.trimTrailingPadding(chars);
            if (!this.alphabet.isValidPaddingStartPosition(chars.length())) {
                return false;
            }
            for (int i = 0; i < chars.length(); ++i) {
                if (this.alphabet.canDecode(chars.charAt(i))) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int decodeTo(byte[] target, CharSequence chars) throws DecodingException {
            void var3_4;
            Preconditions.checkNotNull(target);
            chars = this.trimTrailingPadding(chars);
            if (!this.alphabet.isValidPaddingStartPosition(chars.length())) {
                int n = chars.length();
                throw new DecodingException(new StringBuilder(32).append("Invalid input length ").append(n).toString());
            }
            int bytesWritten = 0;
            for (int charIdx = 0; charIdx < chars.length(); charIdx += this.alphabet.charsPerChunk) {
                long chunk = 0L;
                int charsProcessed = 0;
                for (int i = 0; i < this.alphabet.charsPerChunk; ++i) {
                    chunk <<= this.alphabet.bitsPerChar;
                    if (charIdx + i >= chars.length()) continue;
                    chunk |= (long)this.alphabet.decode(chars.charAt(charIdx + charsProcessed++));
                }
                int minOffset = (this.alphabet.bytesPerChunk << 3) - charsProcessed * this.alphabet.bitsPerChar;
                for (int offset = this.alphabet.bytesPerChunk - 1 << 3; offset >= minOffset; offset -= 8) {
                    target[bytesWritten++] = (byte)(chunk >>> offset & 0xFFL);
                }
            }
            return (int)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        public InputStream decodingStream(Reader reader) {
            void var1_1;
            Preconditions.checkNotNull(reader);
            return new InputStream(this, (Reader)var1_1){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                int readChars = 0;
                boolean hitPadding = false;
                final /* synthetic */ Reader val$reader;
                final /* synthetic */ StandardBaseEncoding this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$reader = reader;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int read() throws IOException {
                    while (true) {
                        void var1_1;
                        int readChar;
                        if ((readChar = this.val$reader.read()) == -1) {
                            if (!this.hitPadding && !this.this$0.alphabet.isValidPaddingStartPosition(this.readChars)) {
                                readChar = this.readChars;
                                throw new DecodingException(new StringBuilder(32).append("Invalid input length ").append(readChar).toString());
                            }
                            return -1;
                        }
                        ++this.readChars;
                        char ch = (char)readChar;
                        if (this.this$0.paddingChar != null && this.this$0.paddingChar.charValue() == ch) {
                            if (!(this.hitPadding || this.readChars != 1 && this.this$0.alphabet.isValidPaddingStartPosition(this.readChars - 1))) {
                                int n = this.readChars;
                                throw new DecodingException(new StringBuilder(41).append("Padding cannot start at index ").append(n).toString());
                            }
                            this.hitPadding = true;
                            continue;
                        }
                        if (this.hitPadding) {
                            int n = this.readChars;
                            throw new DecodingException(new StringBuilder(61).append("Expected padding character but found '").append(ch).append("' at index ").append(n).toString());
                        }
                        this.bitBuffer <<= this.this$0.alphabet.bitsPerChar;
                        this.bitBuffer |= this.this$0.alphabet.decode((char)var1_1);
                        this.bitBufferLength += this.this$0.alphabet.bitsPerChar;
                        if (this.bitBufferLength >= 8) break;
                    }
                    this.bitBufferLength -= 8;
                    return this.bitBuffer >> this.bitBufferLength & 0xFF;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int read(byte[] buf, int off, int len) throws IOException {
                    void var2_3;
                    int i;
                    int n = off;
                    Preconditions.checkPositionIndexes(n, n + len, buf.length);
                    for (i = off; i < off + len; ++i) {
                        int b = this.read();
                        if (b == -1) {
                            void var1_2;
                            int read = i - off;
                            if (read == 0) {
                                return -1;
                            }
                            return (int)var1_2;
                        }
                        var1_1[i] = (byte)b;
                    }
                    return i - var2_3;
                }

                @Override
                public void close() throws IOException {
                    this.val$reader.close();
                }
            };
        }

        @Override
        public BaseEncoding omitPadding() {
            if (this.paddingChar == null) {
                return this;
            }
            StandardBaseEncoding standardBaseEncoding = this;
            return standardBaseEncoding.newInstance(standardBaseEncoding.alphabet, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BaseEncoding withPadChar(char padChar) {
            void var1_1;
            if (8 % this.alphabet.bitsPerChar == 0 || this.paddingChar != null && this.paddingChar.charValue() == padChar) {
                return this;
            }
            StandardBaseEncoding standardBaseEncoding = this;
            return standardBaseEncoding.newInstance(standardBaseEncoding.alphabet, Character.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BaseEncoding withSeparator(String separator, int afterEveryChars) {
            void var2_2;
            void var1_1;
            for (int i = 0; i < separator.length(); ++i) {
                Preconditions.checkArgument(!this.alphabet.matches(separator.charAt(i)), "Separator (%s) cannot contain alphabet characters", (Object)separator);
            }
            if (this.paddingChar != null) {
                Preconditions.checkArgument(separator.indexOf(this.paddingChar.charValue()) < 0, "Separator (%s) cannot contain padding character", (Object)separator);
            }
            return new SeparatedBaseEncoding(this, (String)var1_1, (int)var2_2);
        }

        @Override
        public BaseEncoding upperCase() {
            StandardBaseEncoding standardBaseEncoding;
            BaseEncoding result = this.upperCase;
            if (result == null) {
                Alphabet upper = this.alphabet.upperCase();
                this.upperCase = upper == this.alphabet ? this : this.newInstance((Alphabet)((Object)standardBaseEncoding), this.paddingChar);
                standardBaseEncoding = this.upperCase;
            }
            return standardBaseEncoding;
        }

        @Override
        public BaseEncoding lowerCase() {
            StandardBaseEncoding standardBaseEncoding;
            BaseEncoding result = this.lowerCase;
            if (result == null) {
                Alphabet lower = this.alphabet.lowerCase();
                this.lowerCase = lower == this.alphabet ? this : this.newInstance((Alphabet)((Object)standardBaseEncoding), this.paddingChar);
                standardBaseEncoding = this.lowerCase;
            }
            return standardBaseEncoding;
        }

        /*
         * WARNING - void declaration
         */
        BaseEncoding newInstance(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            return new StandardBaseEncoding((Alphabet)var1_1, (Character)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder("BaseEncoding.");
            builder.append(this.alphabet.toString());
            if (8 % this.alphabet.bitsPerChar != 0) {
                if (this.paddingChar == null) {
                    builder.append(".omitPadding()");
                } else {
                    builder.append(".withPadChar('").append(this.paddingChar).append("')");
                }
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            if (other instanceof StandardBaseEncoding) {
                void var1_1;
                StandardBaseEncoding that = (StandardBaseEncoding)other;
                return this.alphabet.equals(that.alphabet) && Objects.equal(this.paddingChar, var1_1.paddingChar);
            }
            return false;
        }

        public int hashCode() {
            return this.alphabet.hashCode() ^ Objects.hashCode(this.paddingChar);
        }
    }

    private static final class Alphabet {
        private final String name;
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        final int bytesPerChunk;
        private final byte[] decodabet;
        private final boolean[] validPadding;

        /*
         * WARNING - void declaration
         */
        Alphabet(String name, char[] chars) {
            void var1_4;
            void var3_8;
            this.name = Preconditions.checkNotNull(name);
            this.chars = Preconditions.checkNotNull(chars);
            try {
                this.bitsPerChar = IntMath.log2(chars.length, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException e) {
                int n = chars.length;
                throw new IllegalArgumentException(new StringBuilder(35).append("Illegal alphabet length ").append(n).toString(), e);
            }
            int gcd = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            try {
                this.charsPerChunk = 8 / gcd;
                this.bytesPerChunk = this.bitsPerChar / gcd;
            }
            catch (ArithmeticException e) {
                String string = String.valueOf(new String(chars));
                throw new IllegalArgumentException(string.length() != 0 ? "Illegal alphabet ".concat(string) : new String("Illegal alphabet "), e);
            }
            this.mask = chars.length - 1;
            byte[] decodabet = new byte[128];
            Arrays.fill(decodabet, (byte)-1);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                Preconditions.checkArgument(c < decodabet.length, "Non-ASCII character: %s", c);
                Preconditions.checkArgument(decodabet[c] == -1, "Duplicate character: %s", c);
                decodabet[c] = (byte)i;
            }
            this.decodabet = var3_8;
            boolean[] validPadding = new boolean[this.charsPerChunk];
            for (int i = 0; i < this.bytesPerChunk; ++i) {
                validPadding[IntMath.divide((int)(i << 3), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
            }
            this.validPadding = var1_4;
        }

        /*
         * WARNING - void declaration
         */
        final char encode(int bits) {
            void var1_1;
            return this.chars[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        final boolean isValidPaddingStartPosition(int index) {
            void var1_1;
            return this.validPadding[var1_1 % this.charsPerChunk];
        }

        /*
         * WARNING - void declaration
         */
        final boolean canDecode(char ch) {
            void var1_1;
            return ch <= '\u007f' && this.decodabet[var1_1] != -1;
        }

        /*
         * WARNING - void declaration
         */
        final int decode(char ch) throws DecodingException {
            void var2_2;
            if (ch > '\u007f') {
                String string = String.valueOf(Integer.toHexString(ch));
                throw new DecodingException(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
            }
            byte result = this.decodabet[ch];
            if (result == -1) {
                void var1_1;
                if (ch <= ' ' || ch == '\u007f') {
                    String string = String.valueOf(Integer.toHexString(ch));
                    throw new DecodingException(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
                }
                throw new DecodingException(new StringBuilder(25).append("Unrecognized character: ").append((char)var1_1).toString());
            }
            return (int)var2_2;
        }

        private boolean hasLowerCase() {
            char[] cArray = this.chars;
            int n = this.chars.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (!Ascii.isLowerCase(c)) continue;
                return true;
            }
            return false;
        }

        private boolean hasUpperCase() {
            char[] cArray = this.chars;
            int n = this.chars.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (!Ascii.isUpperCase(c)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final Alphabet upperCase() {
            void var1_1;
            if (!this.hasLowerCase()) {
                return this;
            }
            Preconditions.checkState(!this.hasUpperCase(), "Cannot call upperCase() on a mixed-case alphabet");
            char[] upperCased = new char[this.chars.length];
            for (int i = 0; i < this.chars.length; ++i) {
                upperCased[i] = Ascii.toUpperCase(this.chars[i]);
            }
            return new Alphabet(String.valueOf(this.name).concat(".upperCase()"), (char[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final Alphabet lowerCase() {
            void var1_1;
            if (!this.hasUpperCase()) {
                return this;
            }
            Preconditions.checkState(!this.hasLowerCase(), "Cannot call lowerCase() on a mixed-case alphabet");
            char[] lowerCased = new char[this.chars.length];
            for (int i = 0; i < this.chars.length; ++i) {
                lowerCased[i] = Ascii.toLowerCase(this.chars[i]);
            }
            return new Alphabet(String.valueOf(this.name).concat(".lowerCase()"), (char[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean matches(char c) {
            void var1_1;
            return c < this.decodabet.length && this.decodabet[var1_1] != -1;
        }

        public final String toString() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            if (other instanceof Alphabet) {
                void var1_1;
                Alphabet that = (Alphabet)other;
                return Arrays.equals(this.chars, var1_1.chars);
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(this.chars);
        }
    }

    public static final class DecodingException
    extends IOException {
        /*
         * WARNING - void declaration
         */
        DecodingException(String message) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        DecodingException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }
}

