/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class AppendableWriter
extends Writer {
    private final Appendable target;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    AppendableWriter(Appendable target) {
        void var1_1;
        this.target = (Appendable)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkNotClosed();
        this.target.append(new String((char[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int c) throws IOException {
        void var1_1;
        this.checkNotClosed();
        this.target.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String str) throws IOException {
        void var1_1;
        Preconditions.checkNotNull(str);
        this.checkNotClosed();
        this.target.append((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String str, int off, int len) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(str);
        this.checkNotClosed();
        void v0 = var2_2;
        this.target.append((CharSequence)var1_1, (int)v0, (int)(v0 + var3_3));
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        if (this.target instanceof Flushable) {
            ((Flushable)((Object)this.target)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.target instanceof Closeable) {
            ((Closeable)((Object)this.target)).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Writer append(char c) throws IOException {
        void var1_1;
        this.checkNotClosed();
        this.target.append((char)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Writer append(CharSequence charSeq) throws IOException {
        void var1_1;
        this.checkNotClosed();
        this.target.append((CharSequence)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Writer append(CharSequence charSeq, int start, int end) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkNotClosed();
        this.target.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed writer.");
        }
    }
}

