/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class Striped64
extends Number {
    static final ThreadLocal<int[]> threadHashCode = new ThreadLocal();
    static final Random rng = new Random();
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int busy;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;

    Striped64() {
    }

    /*
     * WARNING - void declaration
     */
    final boolean casBase(long cmp, long val) {
        void var3_2;
        void var1_1;
        return UNSAFE.compareAndSwapLong(this, baseOffset, (long)var1_1, (long)var3_2);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    /*
     * WARNING - void declaration
     */
    final void retryUpdate(long x, int[] hc, boolean wasUncontended) {
        int h;
        if (hc == null) {
            hc = new int[1];
            threadHashCode.set(hc);
            int r = rng.nextInt();
            hc[0] = r == 0 ? 1 : r;
            h = hc[0];
        } else {
            h = hc[0];
        }
        boolean collide = false;
        while (true) {
            void var7_9;
            int n;
            Cell[] as = this.cells;
            if (this.cells != null && (n = as.length) > 0) {
                Cell r;
                Cell a = as[n - 1 & h];
                if (a == null) {
                    if (this.busy == 0) {
                        r = new Cell(x);
                        if (this.busy == 0 && this.casBusy()) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                Cell[] rs = this.cells;
                                if (this.cells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.busy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    int n2;
                    void v0 = r;
                    long v = v0.value;
                    if (v0.cas(v, this.fn(v, x))) break;
                    if (n2 >= NCPU || this.cells != var7_9) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.busy == 0 && this.casBusy()) {
                        try {
                            if (this.cells == var7_9) {
                                Cell[] rs = new Cell[n2 << 1];
                                for (int i = 0; i < n2; ++i) {
                                    rs[i] = var7_9[i];
                                }
                                this.cells = rs;
                            }
                        }
                        finally {
                            this.busy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                int n3 = h;
                h = n3 ^ n3 << 13;
                h ^= h >>> 17;
                h ^= h << 5;
                hc[0] = h;
                continue;
            }
            if (this.busy == 0 && this.cells == var7_9 && this.casBusy()) {
                boolean init = false;
                try {
                    if (this.cells == var7_9) {
                        Cell[] cellArray = new Cell[2];
                        Cell[] rs = cellArray;
                        cellArray[h & 1] = new Cell(x);
                        this.cells = rs;
                        init = true;
                    }
                }
                finally {
                    this.busy = 0;
                }
                if (init) break;
                continue;
            }
            Striped64 striped64 = this;
            long v = striped64.base;
            if (striped64.casBase(v, this.fn(v, x))) break;
        }
    }

    final void internalReset(long initialValue) {
        Cell[] as = this.cells;
        this.base = initialValue;
        if (as != null) {
            for (Cell a : as) {
                if (a == null) continue;
                a.value = initialValue;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : Unsafe.class.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                void var0;
                throw new RuntimeException("Could not initialize intrinsics", var0.getCause());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            UNSAFE = Striped64.getUnsafe();
            Class<Striped64> sk = Striped64.class;
            baseOffset = UNSAFE.objectFieldOffset(sk.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(sk.getDeclaredField("busy"));
            return;
        }
        catch (Exception e) {
            void var0_1;
            throw new Error((Throwable)var0_1);
        }
    }

    static final class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        /*
         * WARNING - void declaration
         */
        Cell(long x) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final boolean cas(long cmp, long val) {
            void var3_2;
            void var1_1;
            return UNSAFE.compareAndSwapLong(this, valueOffset, (long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                Class<Cell> ak = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(ak.getDeclaredField("value"));
                return;
            }
            catch (Exception e) {
                void var0_1;
                throw new Error((Throwable)var0_1);
            }
        }
    }
}

