/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.nio.ByteBuffer;

@ElementTypesAreNonnullByDefault
final class SipHashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction SIP_HASH_24 = new SipHashFunction(2, 4, 506097522914230528L, 1084818905618843912L);
    private final int c;
    private final int d;
    private final long k0;
    private final long k1;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    SipHashFunction(int c, int d, long k0, long k1) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(c > 0, "The number of SipRound iterations (c=%s) during Compression must be positive.", c);
        Preconditions.checkArgument(d > 0, "The number of SipRound iterations (d=%s) during Finalization must be positive.", d);
        this.c = var1_1;
        this.d = var2_2;
        this.k0 = var3_3;
        this.k1 = k1;
    }

    @Override
    public final int bits() {
        return 64;
    }

    @Override
    public final Hasher newHasher() {
        return new SipHasher(this.c, this.d, this.k0, this.k1);
    }

    public final String toString() {
        int n = this.c;
        int n2 = this.d;
        long l = this.k0;
        long l2 = this.k1;
        return new StringBuilder(81).append("Hashing.sipHash").append(n).append(n2).append("(").append(l).append(", ").append(l2).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof SipHashFunction) {
            void var1_1;
            SipHashFunction other = (SipHashFunction)object;
            return this.c == other.c && this.d == other.d && this.k0 == other.k0 && this.k1 == var1_1.k1;
        }
        return false;
    }

    public final int hashCode() {
        return (int)((long)(this.getClass().hashCode() ^ this.c ^ this.d) ^ this.k0 ^ this.k1);
    }

    private static final class SipHasher
    extends AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 8;
        private final int c;
        private final int d;
        private long v0 = 8317987319222330741L;
        private long v1 = 7237128888997146477L;
        private long v2 = 7816392313619706465L;
        private long v3 = 8387220255154660723L;
        private long b = 0L;
        private long finalM = 0L;

        /*
         * WARNING - void declaration
         */
        SipHasher(int c, int d, long k0, long k1) {
            super(8);
            void var3_3;
            void var2_2;
            void var1_1;
            this.c = var1_1;
            this.d = var2_2;
            this.v0 ^= k0;
            this.v1 ^= k1;
            this.v2 ^= var3_3;
            this.v3 ^= k1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void process(ByteBuffer buffer) {
            void var1_1;
            this.b += 8L;
            this.processM(var1_1.getLong());
        }

        @Override
        protected final void processRemaining(ByteBuffer buffer) {
            this.b += (long)buffer.remaining();
            int i = 0;
            while (buffer.hasRemaining()) {
                this.finalM ^= ((long)buffer.get() & 0xFFL) << i;
                i += 8;
            }
        }

        @Override
        protected final HashCode makeHash() {
            this.finalM ^= this.b << 56;
            SipHasher sipHasher = this;
            sipHasher.processM(sipHasher.finalM);
            this.v2 ^= 0xFFL;
            SipHasher sipHasher2 = this;
            sipHasher2.sipRound(sipHasher2.d);
            return HashCode.fromLong(this.v0 ^ this.v1 ^ this.v2 ^ this.v3);
        }

        /*
         * WARNING - void declaration
         */
        private void processM(long m) {
            void var1_1;
            this.v3 ^= m;
            SipHasher sipHasher = this;
            sipHasher.sipRound(sipHasher.c);
            this.v0 ^= var1_1;
        }

        private void sipRound(int iterations) {
            for (int i = 0; i < iterations; ++i) {
                this.v0 += this.v1;
                this.v2 += this.v3;
                this.v1 = Long.rotateLeft(this.v1, 13);
                this.v3 = Long.rotateLeft(this.v3, 16);
                this.v1 ^= this.v0;
                this.v3 ^= this.v2;
                this.v0 = Long.rotateLeft(this.v0, 32);
                this.v2 += this.v1;
                this.v0 += this.v3;
                this.v1 = Long.rotateLeft(this.v1, 17);
                this.v3 = Long.rotateLeft(this.v3, 21);
                this.v1 ^= this.v2;
                this.v3 ^= this.v0;
                this.v2 = Long.rotateLeft(this.v2, 32);
            }
        }
    }
}

