/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0, false);
    static final HashFunction MURMUR3_32_FIXED = new Murmur3_32HashFunction(0, true);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED, true);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private final boolean supplementaryPlaneFix;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    Murmur3_32HashFunction(int seed, boolean supplementaryPlaneFix) {
        void var2_2;
        void var1_1;
        this.seed = var1_1;
        this.supplementaryPlaneFix = var2_2;
    }

    @Override
    public final int bits() {
        return 32;
    }

    @Override
    public final Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public final String toString() {
        int n = this.seed;
        return new StringBuilder(31).append("Hashing.murmur3_32(").append(n).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            void var1_1;
            Murmur3_32HashFunction other = (Murmur3_32HashFunction)object;
            return this.seed == other.seed && this.supplementaryPlaneFix == var1_1.supplementaryPlaneFix;
        }
        return false;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public final HashCode hashInt(int input) {
        int n;
        int k1 = Murmur3_32HashFunction.mixK1(input);
        n = Murmur3_32HashFunction.mixH1(this.seed, n);
        return Murmur3_32HashFunction.fmix(n, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashCode hashLong(long input) {
        void var2_4;
        int n;
        void var1_2;
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k1 = Murmur3_32HashFunction.mixK1(low);
        int h1 = Murmur3_32HashFunction.mixH1(this.seed, k1);
        k1 = Murmur3_32HashFunction.mixK1((int)var1_2);
        n = Murmur3_32HashFunction.mixH1(n, (int)var2_4);
        return Murmur3_32HashFunction.fmix(n, 8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashCode hashUnencodedChars(CharSequence input) {
        void var1_1;
        void var2_2;
        int i;
        int h1 = this.seed;
        for (i = 1; i < input.length(); i += 2) {
            int n = input.charAt(i - 1) | input.charAt(i) << 16;
            int k1 = Murmur3_32HashFunction.mixK1(n);
            h1 = Murmur3_32HashFunction.mixH1(h1, k1);
        }
        if ((input.length() & 1) == 1) {
            void var3_3;
            CharSequence charSequence = input;
            char c = charSequence.charAt(charSequence.length() - 1);
            i = c;
            int k1 = Murmur3_32HashFunction.mixK1(c);
            h1 ^= var3_3;
        }
        return Murmur3_32HashFunction.fmix((int)var2_2, 2 * var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashCode hashString(CharSequence input, Charset charset) {
        void var2_2;
        void var1_1;
        if (Charsets.UTF_8.equals(charset)) {
            int k1;
            int utf16Length = input.length();
            int h1 = this.seed;
            int i = 0;
            int len = 0;
            while (i + 4 <= utf16Length) {
                char c0 = input.charAt(i);
                char c1 = input.charAt(i + 1);
                char c2 = input.charAt(i + 2);
                char c3 = input.charAt(i + 3);
                if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c3 >= '\u0080') break;
                int n = c0 | c1 << 8 | c2 << 16 | c3 << 24;
                k1 = Murmur3_32HashFunction.mixK1(n);
                h1 = Murmur3_32HashFunction.mixH1(h1, k1);
                i += 4;
                len += 4;
            }
            long buffer = 0L;
            int shift = 0;
            while (i < utf16Length) {
                char c = input.charAt(i);
                if (c < '\u0080') {
                    buffer |= (long)c << shift;
                    shift += 8;
                    ++len;
                } else if (c < '\u0800') {
                    buffer |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c) << shift;
                    shift += 16;
                    len += 2;
                } else if (c < '\ud800' || c > '\udfff') {
                    buffer |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c) << shift;
                    shift += 24;
                    len += 3;
                } else {
                    int codePoint = Character.codePointAt(input, i);
                    if (codePoint == c) {
                        return this.hashBytes(input.toString().getBytes(charset));
                    }
                    ++i;
                    buffer |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint) << shift;
                    if (this.supplementaryPlaneFix) {
                        shift += 32;
                    }
                    len += 4;
                }
                if (shift >= 32) {
                    k1 = Murmur3_32HashFunction.mixK1((int)buffer);
                    h1 = Murmur3_32HashFunction.mixH1(h1, k1);
                    buffer >>>= 32;
                    shift -= 32;
                }
                ++i;
            }
            int k12 = Murmur3_32HashFunction.mixK1((int)buffer);
            int n = h1 ^ k12;
            return Murmur3_32HashFunction.fmix(n, len);
        }
        return this.hashBytes(var1_1.toString().getBytes((Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashCode hashBytes(byte[] input, int off, int len) {
        void var3_3;
        int k1;
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, input.length);
        int h1 = this.seed;
        int i = 0;
        while (i + 4 <= len) {
            k1 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(input, off + i));
            h1 = Murmur3_32HashFunction.mixH1(h1, k1);
            i += 4;
        }
        k1 = 0;
        int shift = 0;
        while (i < len) {
            k1 ^= UnsignedBytes.toInt(input[off + i]) << shift;
            ++i;
            shift += 8;
        }
        int n2 = h1 ^ Murmur3_32HashFunction.mixK1(k1);
        return Murmur3_32HashFunction.fmix(n2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static int getIntLittleEndian(byte[] input, int offset) {
        void var1_1;
        byte[] byArray;
        return Ints.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], byArray[var1_1]);
    }

    private static int mixK1(int k1) {
        int n = k1 * -862048943;
        n = Integer.rotateLeft(n, 15);
        return n *= 461845907;
    }

    /*
     * WARNING - void declaration
     */
    private static int mixH1(int h1, int k1) {
        void var1_1;
        int n = h1 ^ var1_1;
        n = Integer.rotateLeft(n, 13);
        n = n * 5 + -430675100;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static HashCode fmix(int h1, int length) {
        int n;
        void var1_1;
        h1 ^= var1_1;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        n = (h1 *= -1028477387) ^ n >>> 16;
        return HashCode.fromInt(n);
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        int n;
        return 0xF0L | (long)(codePoint >>> 18) | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & n)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c) {
        char c2;
        return 0xE0L | (long)(c >>> 12) | (long)((0x80 | 0x3F & c >>> 6) << 8) | (long)((0x80 | 0x3F & c2) << 16);
    }

    private static long charToTwoUtf8Bytes(char c) {
        char c2;
        return 0xC0L | (long)(c >>> 6) | (long)((0x80 | 0x3F & c2) << 8);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(int x0, int x1) {
        void var1_1;
        return Murmur3_32HashFunction.mixH1(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$200(byte[] x0, int x1) {
        void var1_1;
        return Murmur3_32HashFunction.getIntLittleEndian(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HashCode access$600(int x0, int x1) {
        void var1_1;
        return Murmur3_32HashFunction.fmix(x0, (int)var1_1);
    }

    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        /*
         * WARNING - void declaration
         */
        Murmur3_32Hasher(int seed) {
            void var1_1;
            this.h1 = var1_1;
            this.length = 0;
            this.isDone = false;
        }

        /*
         * WARNING - void declaration
         */
        private void update(int nBytes, long update) {
            void var1_1;
            void var2_2;
            this.buffer |= (var2_2 & 0xFFFFFFFFL) << this.shift;
            this.shift += nBytes << 3;
            this.length += var1_1;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.access$100(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putByte(byte b) {
            void var1_1;
            this.update(1, (long)(var1_1 & 0xFF));
            return this;
        }

        @Override
        public final Hasher putBytes(byte[] bytes, int off, int len) {
            int n = off;
            Preconditions.checkPositionIndexes(n, n + len, bytes.length);
            int i = 0;
            while (i + 4 <= len) {
                this.update(4, Murmur3_32HashFunction.access$200(bytes, off + i));
                i += 4;
            }
            while (i < len) {
                this.putByte(bytes[off + i]);
                ++i;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putBytes(ByteBuffer buffer) {
            void var2_2;
            void var1_1;
            ByteOrder bo = buffer.order();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.remaining() >= 4) {
                this.putInt(buffer.getInt());
            }
            while (buffer.hasRemaining()) {
                this.putByte(buffer.get());
            }
            var1_1.order((ByteOrder)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putInt(int i) {
            void var1_1;
            this.update(4, (long)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putLong(long l) {
            void var1_1;
            this.update(4, (int)l);
            this.update(4, (long)(var1_1 >>> 32));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putChar(char c) {
            void var1_1;
            this.update(2, (long)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putString(CharSequence input, Charset charset) {
            void var2_2;
            void var1_1;
            if (Charsets.UTF_8.equals(charset)) {
                int utf16Length = input.length();
                int i = 0;
                while (i + 4 <= utf16Length) {
                    char c0 = input.charAt(i);
                    char c1 = input.charAt(i + 1);
                    char c2 = input.charAt(i + 2);
                    char c3 = input.charAt(i + 3);
                    if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c3 >= '\u0080') break;
                    this.update(4, c0 | c1 << 8 | c2 << 16 | c3 << 24);
                    i += 4;
                }
                while (i < utf16Length) {
                    char c = input.charAt(i);
                    if (c < '\u0080') {
                        this.update(1, c);
                    } else if (c < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c));
                    } else if (c < '\ud800' || c > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c));
                    } else {
                        int codePoint = Character.codePointAt(input, i);
                        if (codePoint == c) {
                            this.putBytes(input.subSequence(i, utf16Length).toString().getBytes(charset));
                            return this;
                        }
                        ++i;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint));
                    }
                    ++i;
                }
                return this;
            }
            return super.putString((CharSequence)var1_1, (Charset)var2_2);
        }

        @Override
        public final HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.access$600(this.h1, this.length);
        }
    }
}

