/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

@ElementTypesAreNonnullByDefault
final class MessageDigestHashFunction
extends AbstractHashFunction
implements Serializable {
    private final MessageDigest prototype;
    private final int bytes;
    private final boolean supportsClone;
    private final String toString;

    /*
     * WARNING - void declaration
     */
    MessageDigestHashFunction(String algorithmName, String toString) {
        void var2_2;
        void var1_1;
        this.prototype = MessageDigestHashFunction.getMessageDigest((String)var1_1);
        this.bytes = this.prototype.getDigestLength();
        this.toString = (String)Preconditions.checkNotNull(var2_2);
        this.supportsClone = MessageDigestHashFunction.supportsClone(this.prototype);
    }

    /*
     * WARNING - void declaration
     */
    MessageDigestHashFunction(String algorithmName, int bytes, String toString) {
        void var2_3;
        void var1_2;
        void var3_4;
        this.toString = (String)Preconditions.checkNotNull(var3_4);
        this.prototype = MessageDigestHashFunction.getMessageDigest(algorithmName);
        int maxLength = this.prototype.getDigestLength();
        Preconditions.checkArgument(bytes >= 4 && bytes <= maxLength, "bytes (%s) must be >= 4 and < %s", bytes, (int)var1_2);
        this.bytes = var2_3;
        this.supportsClone = MessageDigestHashFunction.supportsClone(this.prototype);
    }

    private static boolean supportsClone(MessageDigest digest) {
        try {
            digest.clone();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }

    @Override
    public final int bits() {
        return this.bytes << 3;
    }

    public final String toString() {
        return this.toString;
    }

    /*
     * WARNING - void declaration
     */
    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    @Override
    public final Hasher newHasher() {
        if (this.supportsClone) {
            try {
                return new MessageDigestHasher((MessageDigest)this.prototype.clone(), this.bytes);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.prototype.getAlgorithm()), this.bytes);
    }

    final Object writeReplace() {
        return new SerializedForm(this.prototype.getAlgorithm(), this.bytes, this.toString);
    }

    private static final class MessageDigestHasher
    extends AbstractByteHasher {
        private final MessageDigest digest;
        private final int bytes;
        private boolean done;

        /*
         * WARNING - void declaration
         */
        private MessageDigestHasher(MessageDigest digest, int bytes) {
            void var2_2;
            void var1_1;
            this.digest = var1_1;
            this.bytes = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte b) {
            void var1_1;
            this.checkNotDone();
            this.digest.update((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte[] b, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkNotDone();
            this.digest.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(ByteBuffer bytes) {
            void var1_1;
            this.checkNotDone();
            this.digest.update((ByteBuffer)var1_1);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot re-use a Hasher after calling hash() on it");
        }

        @Override
        public final HashCode hash() {
            this.checkNotDone();
            this.done = true;
            if (this.bytes == this.digest.getDigestLength()) {
                return HashCode.fromBytesNoCopy(this.digest.digest());
            }
            return HashCode.fromBytesNoCopy(Arrays.copyOf(this.digest.digest(), this.bytes));
        }
    }

    private static final class SerializedForm
    implements Serializable {
        private final String algorithmName;
        private final int bytes;
        private final String toString;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SerializedForm(String algorithmName, int bytes, String toString) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.algorithmName = var1_1;
            this.bytes = var2_2;
            this.toString = var3_3;
        }

        private Object readResolve() {
            return new MessageDigestHashFunction(this.algorithmName, this.bytes, this.toString);
        }
    }
}

