/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

@ElementTypesAreNonnullByDefault
final class MacHashFunction
extends AbstractHashFunction {
    private final Mac prototype;
    private final Key key;
    private final String toString;
    private final int bits;
    private final boolean supportsClone;

    /*
     * WARNING - void declaration
     */
    MacHashFunction(String algorithmName, Key key, String toString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.prototype = MacHashFunction.getMac((String)var1_1, key);
        this.key = (Key)Preconditions.checkNotNull(var2_2);
        this.toString = (String)Preconditions.checkNotNull(var3_3);
        this.bits = this.prototype.getMacLength() << 3;
        this.supportsClone = MacHashFunction.supportsClone(this.prototype);
    }

    @Override
    public final int bits() {
        return this.bits;
    }

    private static boolean supportsClone(Mac mac) {
        try {
            mac.clone();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Mac getMac(String algorithmName, Key key) {
        try {
            void var1_3;
            Mac mac = Mac.getInstance(algorithmName);
            mac.init((Key)var1_3);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            void var0_2;
            throw new IllegalArgumentException((Throwable)var0_2);
        }
    }

    @Override
    public final Hasher newHasher() {
        if (this.supportsClone) {
            try {
                return new MacHasher((Mac)this.prototype.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return new MacHasher(MacHashFunction.getMac(this.prototype.getAlgorithm(), this.key));
    }

    public final String toString() {
        return this.toString;
    }

    private static final class MacHasher
    extends AbstractByteHasher {
        private final Mac mac;
        private boolean done;

        /*
         * WARNING - void declaration
         */
        private MacHasher(Mac mac) {
            void var1_1;
            this.mac = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte b) {
            void var1_1;
            this.checkNotDone();
            this.mac.update((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte[] b) {
            void var1_1;
            this.checkNotDone();
            this.mac.update((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte[] b, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checkNotDone();
            this.mac.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(ByteBuffer bytes) {
            void var1_1;
            this.checkNotDone();
            Preconditions.checkNotNull(bytes);
            this.mac.update((ByteBuffer)var1_1);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot re-use a Hasher after calling hash() on it");
        }

        @Override
        public final HashCode hash() {
            this.checkNotDone();
            this.done = true;
            return HashCode.fromBytesNoCopy(this.mac.doFinal());
        }
    }
}

