/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    /*
     * WARNING - void declaration
     */
    static long load64(byte[] input, int offset) {
        void var1_1;
        byte[] byArray;
        assert (input.length >= offset + 8);
        return byteArray.getLongLittleEndian(byArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static long load64Safely(byte[] input, int offset, int length) {
        void var3_3;
        long result = 0L;
        int limit = Math.min(length, 8);
        for (int i = 0; i < limit; ++i) {
            result |= ((long)input[offset + i] & 0xFFL) << (i << 3);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static void store64(byte[] sink, int offset, long value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        assert (offset >= 0 && offset + 8 <= sink.length);
        byteArray.putLongLittleEndian(byArray, (int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int load32(byte[] source, int offset) {
        void var1_1;
        byte[] byArray;
        return source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8 | (source[offset + 2] & 0xFF) << 16 | (byArray[var1_1 + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            void var1_1;
            String arch = System.getProperty("os.arch");
            if ("amd64".equals(var1_1)) {
                theGetter = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {}
        byteArray = var0;
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            /*
             * WARNING - void declaration
             */
            @Override
            public final long getLongLittleEndian(byte[] source, int offset) {
                void var2_2;
                void var1_1;
                return Longs.fromBytes(source[offset + 7], source[offset + 6], source[offset + 5], source[offset + 4], source[offset + 3], source[offset + 2], source[offset + 1], (byte)var1_1[var2_2]);
            }

            @Override
            public final void putLongLittleEndian(byte[] sink, int offset, long value) {
                long mask = 255L;
                for (int i = 0; i < 8; ++i) {
                    sink[offset + i] = (byte)((value & mask) >> (i << 3));
                    mask <<= 8;
                }
            }
        };

    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            /*
             * WARNING - void declaration
             */
            @Override
            public final long getLongLittleEndian(byte[] array, int offset) {
                void var2_2;
                void var1_1;
                return theUnsafe.getLong(var1_1, (long)var2_2 + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void putLongLittleEndian(byte[] array, int offset, long value) {
                void var3_3;
                void var2_2;
                void var1_1;
                theUnsafe.putLong(var1_1, (long)var2_2 + (long)BYTE_ARRAY_BASE_OFFSET, (long)var3_3);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            /*
             * WARNING - void declaration
             */
            @Override
            public final long getLongLittleEndian(byte[] array, int offset) {
                void var2_2;
                void var1_1;
                long l = theUnsafe.getLong(var1_1, (long)var2_2 + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(l);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void putLongLittleEndian(byte[] array, int offset, long value) {
                void var2_2;
                void var1_1;
                long littleEndianValue = Long.reverseBytes(value);
                theUnsafe.putLong(var1_1, (long)var2_2 + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        /*
         * WARNING - void declaration
         */
        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : Unsafe.class.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    void var0;
                    throw new RuntimeException("Could not initialize intrinsics", var0.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

