/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    /*
     * WARNING - void declaration
     */
    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super((OutputStream)Preconditions.checkNotNull(var2_2));
        void var1_1;
        void var2_2;
        this.hasher = Preconditions.checkNotNull(var1_1.newHasher());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(int b) throws IOException {
        void var1_1;
        this.hasher.putByte((byte)b);
        this.out.write((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] bytes, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.hasher.putBytes(bytes, off, len);
        this.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    public final HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }
}

