/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    /*
     * WARNING - void declaration
     */
    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super((InputStream)Preconditions.checkNotNull(var2_2));
        void var1_1;
        void var2_2;
        this.hasher = Preconditions.checkNotNull(var1_1.newHasher());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read() throws IOException {
        void var1_1;
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] bytes, int off, int len) throws IOException {
        void var3_3;
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            void var2_2;
            void var1_1;
            this.hasher.putBytes((byte[])var1_1, (int)var2_2, numOfBytesRead);
        }
        return (int)var3_3;
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final void mark(int readlimit) {
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public final HashCode hash() {
        return this.hasher.hash();
    }
}

