/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractCompositeHashFunction;
import com.google.common.hash.ChecksumHashFunction;
import com.google.common.hash.Crc32cHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.FarmHashFingerprint64;
import com.google.common.hash.Fingerprint2011;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.ImmutableSupplier;
import com.google.common.hash.MacHashFunction;
import com.google.common.hash.MessageDigestHashFunction;
import com.google.common.hash.Murmur3_128HashFunction;
import com.google.common.hash.Murmur3_32HashFunction;
import com.google.common.hash.SipHashFunction;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.crypto.spec.SecretKeySpec;

@ElementTypesAreNonnullByDefault
public final class Hashing {
    static final int GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();

    /*
     * WARNING - void declaration
     */
    public static HashFunction goodFastHash(int minimumBits) {
        void var1_1;
        int bits = Hashing.checkPositiveAndMakeMultipleOf32(minimumBits);
        if (bits == 32) {
            return Murmur3_32HashFunction.GOOD_FAST_HASH_32;
        }
        if (bits <= 128) {
            return Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        }
        int hashFunctionsNeeded = (bits + 127) / 128;
        HashFunction[] hashFunctionArray = new HashFunction[hashFunctionsNeeded];
        HashFunction[] hashFunctions = hashFunctionArray;
        hashFunctionArray[0] = Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        int seed = GOOD_FAST_HASH_SEED;
        for (int i = 1; i < hashFunctionsNeeded; ++i) {
            hashFunctions[i] = Hashing.murmur3_128(seed += 1500450271);
        }
        return new ConcatenatedHashFunction((HashFunction[])var1_1);
    }

    @Deprecated
    public static HashFunction murmur3_32(int seed) {
        int n;
        return new Murmur3_32HashFunction(n, false);
    }

    @Deprecated
    public static HashFunction murmur3_32() {
        return Murmur3_32HashFunction.MURMUR3_32;
    }

    public static HashFunction murmur3_32_fixed(int seed) {
        int n;
        return new Murmur3_32HashFunction(n, true);
    }

    public static HashFunction murmur3_32_fixed() {
        return Murmur3_32HashFunction.MURMUR3_32_FIXED;
    }

    public static HashFunction murmur3_128(int seed) {
        int n;
        return new Murmur3_128HashFunction(n);
    }

    public static HashFunction murmur3_128() {
        return Murmur3_128HashFunction.MURMUR3_128;
    }

    public static HashFunction sipHash24() {
        return SipHashFunction.SIP_HASH_24;
    }

    /*
     * WARNING - void declaration
     */
    public static HashFunction sipHash24(long k0, long k1) {
        void var2_1;
        long l;
        return new SipHashFunction(2, 4, l, (long)var2_1);
    }

    @Deprecated
    public static HashFunction md5() {
        return Md5Holder.MD5;
    }

    @Deprecated
    public static HashFunction sha1() {
        return Sha1Holder.SHA_1;
    }

    public static HashFunction sha256() {
        return Sha256Holder.SHA_256;
    }

    public static HashFunction sha384() {
        return Sha384Holder.SHA_384;
    }

    public static HashFunction sha512() {
        return Sha512Holder.SHA_512;
    }

    public static HashFunction hmacMd5(Key key) {
        Key key2;
        return new MacHashFunction("HmacMD5", key, Hashing.hmacToString("hmacMd5", key2));
    }

    public static HashFunction hmacMd5(byte[] key) {
        byte[] byArray;
        return Hashing.hmacMd5(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacMD5"));
    }

    public static HashFunction hmacSha1(Key key) {
        Key key2;
        return new MacHashFunction("HmacSHA1", key, Hashing.hmacToString("hmacSha1", key2));
    }

    public static HashFunction hmacSha1(byte[] key) {
        byte[] byArray;
        return Hashing.hmacSha1(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA1"));
    }

    public static HashFunction hmacSha256(Key key) {
        Key key2;
        return new MacHashFunction("HmacSHA256", key, Hashing.hmacToString("hmacSha256", key2));
    }

    public static HashFunction hmacSha256(byte[] key) {
        byte[] byArray;
        return Hashing.hmacSha256(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA256"));
    }

    public static HashFunction hmacSha512(Key key) {
        Key key2;
        return new MacHashFunction("HmacSHA512", key, Hashing.hmacToString("hmacSha512", key2));
    }

    public static HashFunction hmacSha512(byte[] key) {
        byte[] byArray;
        return Hashing.hmacSha512(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA512"));
    }

    /*
     * WARNING - void declaration
     */
    private static String hmacToString(String methodName, Key key) {
        void var1_1;
        String string;
        return String.format("Hashing.%s(Key[algorithm=%s, format=%s])", string, key.getAlgorithm(), var1_1.getFormat());
    }

    public static HashFunction crc32c() {
        return Crc32cHashFunction.CRC_32_C;
    }

    public static HashFunction crc32() {
        return ChecksumType.CRC_32.hashFunction;
    }

    public static HashFunction adler32() {
        return ChecksumType.ADLER_32.hashFunction;
    }

    public static HashFunction farmHashFingerprint64() {
        return FarmHashFingerprint64.FARMHASH_FINGERPRINT_64;
    }

    public static HashFunction fingerprint2011() {
        return Fingerprint2011.FINGERPRINT_2011;
    }

    /*
     * WARNING - void declaration
     */
    public static int consistentHash(HashCode hashCode, int buckets) {
        void var1_1;
        return Hashing.consistentHash(hashCode.padToLong(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int consistentHash(long input, int buckets) {
        void var1_3;
        int next;
        Preconditions.checkArgument(buckets > 0, "buckets must be positive: %s", buckets);
        LinearCongruentialGenerator generator = new LinearCongruentialGenerator(input);
        int candidate = 0;
        while ((next = (int)((double)(candidate + 1) / generator.nextDouble())) >= 0 && next < buckets) {
            void var3_4;
            candidate = var3_4;
        }
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static HashCode combineOrdered(Iterable<HashCode> hashCodes) {
        void var1_3;
        Iterator<HashCode> iterator;
        Iterator<HashCode> iterator22 = hashCodes.iterator();
        Preconditions.checkArgument(iterator22.hasNext(), "Must be at least 1 hash code to combine.");
        int iterator22 = iterator22.next().bits();
        byte[] resultBytes = new byte[iterator22 / 8];
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            HashCode hashCode = (HashCode)iterator.next();
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, "All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                resultBytes[i] = (byte)(resultBytes[i] * 37 ^ nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy((byte[])var1_3);
    }

    /*
     * WARNING - void declaration
     */
    public static HashCode combineUnordered(Iterable<HashCode> hashCodes) {
        void var1_1;
        Iterator<HashCode> iterator;
        Iterator<HashCode> iterator2 = hashCodes.iterator();
        Preconditions.checkArgument(iterator2.hasNext(), "Must be at least 1 hash code to combine.");
        byte[] resultBytes = new byte[iterator2.next().bits() / 8];
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            HashCode hashCode = (HashCode)iterator.next();
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, "All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                int n = i;
                resultBytes[n] = (byte)(resultBytes[n] + nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy((byte[])var1_1);
    }

    static int checkPositiveAndMakeMultipleOf32(int bits) {
        int n;
        Preconditions.checkArgument(bits > 0, "Number of bits must be positive");
        return n + 31 & 0xFFFFFFE0;
    }

    /*
     * WARNING - void declaration
     */
    public static HashFunction concatenating(HashFunction first, HashFunction second, HashFunction ... rest) {
        void var3_3;
        void var2_2;
        void var1_1;
        HashFunction hashFunction;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(hashFunction);
        list.add(var1_1);
        Collections.addAll(list, var2_2);
        return new ConcatenatedHashFunction(var3_3.toArray(new HashFunction[0]));
    }

    /*
     * WARNING - void declaration
     */
    public static HashFunction concatenating(Iterable<HashFunction> hashFunctions) {
        void var1_1;
        Iterator<HashFunction> iterator;
        Preconditions.checkNotNull(hashFunctions);
        ArrayList<void> list = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            HashFunction hashFunction = (HashFunction)iterator.next();
            list.add(var2_2);
        }
        Preconditions.checkArgument(!list.isEmpty(), "number of hash functions (%s) must be > 0", list.size());
        return new ConcatenatedHashFunction(var1_1.toArray(new HashFunction[0]));
    }

    private Hashing() {
    }

    private static final class LinearCongruentialGenerator {
        private long state;

        /*
         * WARNING - void declaration
         */
        public LinearCongruentialGenerator(long seed) {
            void var1_1;
            this.state = var1_1;
        }

        public final double nextDouble() {
            this.state = 2862933555777941757L * this.state + 1L;
            return (double)((int)(this.state >>> 33) + 1) / 2.147483648E9;
        }
    }

    private static final class ConcatenatedHashFunction
    extends AbstractCompositeHashFunction {
        /*
         * WARNING - void declaration
         */
        private ConcatenatedHashFunction(HashFunction ... functions) {
            super(functions);
            void var1_1;
            for (void function : var1_1) {
                Preconditions.checkArgument(function.bits() % 8 == 0, "the number of bits (%s) in hashFunction (%s) must be divisible by 8", function.bits(), (Object)function);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final HashCode makeHash(Hasher[] hashers) {
            void var2_2;
            void var1_1;
            byte[] bytes = new byte[this.bits() / 8];
            int i = 0;
            for (void var6_6 : var1_1) {
                HashCode newHash = var6_6.hash();
                i += newHash.writeBytesTo(bytes, i, newHash.bits() / 8);
            }
            return HashCode.fromBytesNoCopy((byte[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int bits() {
            void var1_1;
            int bitSum = 0;
            HashFunction[] hashFunctionArray = this.functions;
            int n = this.functions.length;
            for (int i = 0; i < n; ++i) {
                HashFunction function = hashFunctionArray[i];
                bitSum += function.bits();
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object object) {
            if (object instanceof ConcatenatedHashFunction) {
                void var1_1;
                ConcatenatedHashFunction other = (ConcatenatedHashFunction)object;
                return Arrays.equals(this.functions, var1_1.functions);
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(this.functions);
        }
    }

    static enum ChecksumType implements ImmutableSupplier<Checksum>
    {
        CRC_32("Hashing.crc32()"){
            {
                void var3_3;
            }

            @Override
            public final Checksum get() {
                return new CRC32();
            }
        }
        ,
        ADLER_32("Hashing.adler32()"){
            {
                void var3_3;
            }

            @Override
            public final Checksum get() {
                return new Adler32();
            }
        };

        public final HashFunction hashFunction;

        /*
         * WARNING - void declaration
         */
        private ChecksumType(String toString) {
            void var3_3;
            this.hashFunction = new ChecksumHashFunction(this, 32, (String)var3_3);
        }
    }

    private static class Sha512Holder {
        static final HashFunction SHA_512 = new MessageDigestHashFunction("SHA-512", "Hashing.sha512()");

        private Sha512Holder() {
        }
    }

    private static class Sha384Holder {
        static final HashFunction SHA_384 = new MessageDigestHashFunction("SHA-384", "Hashing.sha384()");

        private Sha384Holder() {
        }
    }

    private static class Sha256Holder {
        static final HashFunction SHA_256 = new MessageDigestHashFunction("SHA-256", "Hashing.sha256()");

        private Sha256Holder() {
        }
    }

    private static class Sha1Holder {
        static final HashFunction SHA_1 = new MessageDigestHashFunction("SHA-1", "Hashing.sha1()");

        private Sha1Holder() {
        }
    }

    private static class Md5Holder {
        static final HashFunction MD5 = new MessageDigestHashFunction("MD5", "Hashing.md5()");

        private Md5Holder() {
        }
    }
}

