/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int bits();

    public abstract int asInt();

    public abstract long asLong();

    public abstract long padToLong();

    public abstract byte[] asBytes();

    /*
     * WARNING - void declaration
     */
    public int writeBytesTo(byte[] dest, int offset, int maxLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        maxLength = Ints.min(maxLength, this.bits() / 8);
        int n = offset;
        Preconditions.checkPositionIndexes(n, n + maxLength, dest.length);
        this.writeBytesToImpl((byte[])var1_1, (int)var2_2, maxLength);
        return (int)var3_3;
    }

    abstract void writeBytesToImpl(byte[] var1, int var2, int var3);

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    abstract boolean equalsSameBits(HashCode var1);

    public static HashCode fromInt(int hash) {
        int n;
        return new IntHashCode(n);
    }

    public static HashCode fromLong(long hash) {
        long l;
        return new LongHashCode(l);
    }

    public static HashCode fromBytes(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length > 0, "A HashCode must contain at least 1 byte.");
        return HashCode.fromBytesNoCopy((byte[])byArray.clone());
    }

    static HashCode fromBytesNoCopy(byte[] bytes) {
        byte[] byArray;
        return new BytesHashCode(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static HashCode fromString(String string) {
        void var1_1;
        Preconditions.checkArgument(string.length() >= 2, "input string (%s) must have at least 2 characters", (Object)string);
        Preconditions.checkArgument(string.length() % 2 == 0, "input string (%s) must have an even number of characters", (Object)string);
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            void var3_3;
            int ch1 = HashCode.decode(string.charAt(i)) << 4;
            int ch2 = HashCode.decode(string.charAt(i + 1));
            bytes[i / 2] = (byte)(var3_3 + ch2);
        }
        return HashCode.fromBytesNoCopy((byte[])var1_1);
    }

    private static int decode(char ch) {
        char c;
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException(new StringBuilder(32).append("Illegal hexadecimal character: ").append(c).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof HashCode) {
            void var1_1;
            HashCode that = (HashCode)object;
            return this.bits() == that.bits() && this.equalsSameBits((HashCode)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var2_2;
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] bytes = this.getBytesInternal();
        int val = bytes[0] & 0xFF;
        for (int i = 1; i < bytes.length; ++i) {
            val |= (bytes[i] & 0xFF) << (i << 3);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        void var1_1;
        byte[] bytes = this.getBytesInternal();
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (void b : var1_1) {
            sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
        }
        return var2_2.toString();
    }

    private static final class BytesHashCode
    extends HashCode
    implements Serializable {
        final byte[] bytes;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        BytesHashCode(byte[] bytes) {
            void var1_1;
            this.bytes = (byte[])Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final int bits() {
            return this.bytes.length << 3;
        }

        @Override
        public final byte[] asBytes() {
            return (byte[])this.bytes.clone();
        }

        @Override
        public final int asInt() {
            Preconditions.checkState(this.bytes.length >= 4, "HashCode#asInt() requires >= 4 bytes (it only has %s bytes).", this.bytes.length);
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        @Override
        public final long asLong() {
            Preconditions.checkState(this.bytes.length >= 8, "HashCode#asLong() requires >= 8 bytes (it only has %s bytes).", this.bytes.length);
            return ((HashCode)this).padToLong();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long padToLong() {
            void var1_1;
            long retVal = this.bytes[0] & 0xFF;
            for (int i = 1; i < Math.min(this.bytes.length, 8); ++i) {
                retVal |= ((long)this.bytes[i] & 0xFFL) << (i << 3);
            }
            return (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeBytesToImpl(byte[] dest, int offset, int maxLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            System.arraycopy(this.bytes, 0, var1_1, (int)var2_2, (int)var3_3);
        }

        @Override
        final byte[] getBytesInternal() {
            return this.bytes;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsSameBits(HashCode that) {
            void var2_2;
            if (this.bytes.length != that.getBytesInternal().length) {
                return false;
            }
            boolean areEqual = true;
            for (int i = 0; i < this.bytes.length; ++i) {
                areEqual &= this.bytes[i] == that.getBytesInternal()[i];
            }
            return (boolean)var2_2;
        }
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        final long hash;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        LongHashCode(long hash) {
            void var1_1;
            this.hash = var1_1;
        }

        @Override
        public final int bits() {
            return 64;
        }

        @Override
        public final byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        @Override
        public final int asInt() {
            return (int)this.hash;
        }

        @Override
        public final long asLong() {
            return this.hash;
        }

        @Override
        public final long padToLong() {
            return this.hash;
        }

        @Override
        final void writeBytesToImpl(byte[] dest, int offset, int maxLength) {
            for (int i = 0; i < maxLength; ++i) {
                dest[offset + i] = (byte)(this.hash >> (i << 3));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsSameBits(HashCode that) {
            void var1_1;
            return this.hash == var1_1.asLong();
        }
    }

    private static final class IntHashCode
    extends HashCode
    implements Serializable {
        final int hash;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        IntHashCode(int hash) {
            void var1_1;
            this.hash = var1_1;
        }

        @Override
        public final int bits() {
            return 32;
        }

        @Override
        public final byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24)};
        }

        @Override
        public final int asInt() {
            return this.hash;
        }

        @Override
        public final long asLong() {
            throw new IllegalStateException("this HashCode only has 32 bits; cannot create a long");
        }

        @Override
        public final long padToLong() {
            return UnsignedInts.toLong(this.hash);
        }

        @Override
        final void writeBytesToImpl(byte[] dest, int offset, int maxLength) {
            for (int i = 0; i < maxLength; ++i) {
                dest[offset + i] = (byte)(this.hash >> (i << 3));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsSameBits(HashCode that) {
            void var1_1;
            return this.hash == var1_1.asInt();
        }
    }
}

