/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
@Beta
public final class Funnels {
    private Funnels() {
    }

    public static Funnel<byte[]> byteArrayFunnel() {
        return ByteArrayFunnel.INSTANCE;
    }

    public static Funnel<CharSequence> unencodedCharsFunnel() {
        return UnencodedCharsFunnel.INSTANCE;
    }

    public static Funnel<CharSequence> stringFunnel(Charset charset) {
        Charset charset2;
        return new StringCharsetFunnel(charset2);
    }

    public static Funnel<Integer> integerFunnel() {
        return IntegerFunnel.INSTANCE;
    }

    public static <E> Funnel<Iterable<? extends E>> sequentialFunnel(Funnel<E> elementFunnel) {
        Funnel<E> funnel;
        return new SequentialFunnel<E>(funnel);
    }

    public static Funnel<Long> longFunnel() {
        return LongFunnel.INSTANCE;
    }

    public static OutputStream asOutputStream(PrimitiveSink sink) {
        PrimitiveSink primitiveSink;
        return new SinkAsStream(primitiveSink);
    }

    private static class SinkAsStream
    extends OutputStream {
        final PrimitiveSink sink;

        /*
         * WARNING - void declaration
         */
        SinkAsStream(PrimitiveSink sink) {
            void var1_1;
            this.sink = (PrimitiveSink)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int b) {
            void var1_1;
            this.sink.putByte((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] bytes) {
            void var1_1;
            this.sink.putBytes((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] bytes, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.sink.putBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        public String toString() {
            String string = String.valueOf(this.sink);
            return new StringBuilder(24 + String.valueOf(string).length()).append("Funnels.asOutputStream(").append(string).append(")").toString();
        }
    }

    private static enum LongFunnel implements Funnel<Long>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final void funnel(Long from, PrimitiveSink into) {
            void var1_1;
            into.putLong(var1_1.longValue());
        }

        public final String toString() {
            return "Funnels.longFunnel()";
        }
    }

    private static class SequentialFunnel<E>
    implements Funnel<Iterable<? extends E>>,
    Serializable {
        private final Funnel<E> elementFunnel;

        /*
         * WARNING - void declaration
         */
        SequentialFunnel(Funnel<E> elementFunnel) {
            void var1_1;
            this.elementFunnel = (Funnel)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void funnel(Iterable<? extends E> from, PrimitiveSink into) {
            for (E e : from) {
                void var3_3;
                this.elementFunnel.funnel(var3_3, into);
            }
        }

        public String toString() {
            String string = String.valueOf(this.elementFunnel);
            return new StringBuilder(26 + String.valueOf(string).length()).append("Funnels.sequentialFunnel(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            if (o instanceof SequentialFunnel) {
                void var1_1;
                SequentialFunnel funnel = (SequentialFunnel)o;
                return this.elementFunnel.equals(var1_1.elementFunnel);
            }
            return false;
        }

        public int hashCode() {
            return SequentialFunnel.class.hashCode() ^ this.elementFunnel.hashCode();
        }
    }

    private static enum IntegerFunnel implements Funnel<Integer>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final void funnel(Integer from, PrimitiveSink into) {
            void var1_1;
            into.putInt(var1_1.intValue());
        }

        public final String toString() {
            return "Funnels.integerFunnel()";
        }
    }

    private static class StringCharsetFunnel
    implements Funnel<CharSequence>,
    Serializable {
        private final Charset charset;

        /*
         * WARNING - void declaration
         */
        StringCharsetFunnel(Charset charset) {
            void var1_1;
            this.charset = (Charset)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void funnel(CharSequence from, PrimitiveSink into) {
            void var1_1;
            into.putString((CharSequence)var1_1, this.charset);
        }

        public String toString() {
            String string = this.charset.name();
            return new StringBuilder(22 + String.valueOf(string).length()).append("Funnels.stringFunnel(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            if (o instanceof StringCharsetFunnel) {
                void var1_1;
                StringCharsetFunnel funnel = (StringCharsetFunnel)o;
                return this.charset.equals(var1_1.charset);
            }
            return false;
        }

        public int hashCode() {
            return StringCharsetFunnel.class.hashCode() ^ this.charset.hashCode();
        }

        Object writeReplace() {
            return new SerializedForm(this.charset);
        }

        private static class SerializedForm
        implements Serializable {
            private final String charsetCanonicalName;
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            SerializedForm(Charset charset) {
                void var1_1;
                this.charsetCanonicalName = var1_1.name();
            }

            private Object readResolve() {
                return Funnels.stringFunnel(Charset.forName(this.charsetCanonicalName));
            }
        }
    }

    private static enum UnencodedCharsFunnel implements Funnel<CharSequence>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final void funnel(CharSequence from, PrimitiveSink into) {
            void var1_1;
            into.putUnencodedChars((CharSequence)var1_1);
        }

        public final String toString() {
            return "Funnels.unencodedCharsFunnel()";
        }
    }

    private static enum ByteArrayFunnel implements Funnel<byte[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final void funnel(byte[] from, PrimitiveSink into) {
            void var1_1;
            into.putBytes((byte[])var1_1);
        }

        public final String toString() {
            return "Funnels.byteArrayFunnel()";
        }
    }
}

