/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.ImmutableSupplier;
import java.io.Serializable;
import java.util.zip.Checksum;

@ElementTypesAreNonnullByDefault
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> checksumSupplier, int bits, String toString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checksumSupplier = (ImmutableSupplier)Preconditions.checkNotNull(var1_1);
        Preconditions.checkArgument(bits == 32 || bits == 64, "bits (%s) must be either 32 or 64", bits);
        this.bits = var2_2;
        this.toString = (String)Preconditions.checkNotNull(var3_3);
    }

    @Override
    public final int bits() {
        return this.bits;
    }

    @Override
    public final Hasher newHasher() {
        ChecksumHashFunction checksumHashFunction = this;
        return checksumHashFunction.new ChecksumHasher((Checksum)checksumHashFunction.checksumSupplier.get());
    }

    public final String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        /*
         * WARNING - void declaration
         */
        private ChecksumHasher(Checksum checksum) {
            void var2_2;
            this.checksum = (Checksum)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte b) {
            void var1_1;
            this.checksum.update((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void update(byte[] bytes, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checksum.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HashCode hash() {
            void var1_1;
            long value = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)value);
            }
            return HashCode.fromLong((long)var1_1);
        }
    }
}

