/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.hash.LongAddable;
import com.google.common.hash.LongAddables;
import com.google.common.hash.ParametricNullness;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;

@ElementTypesAreNonnullByDefault
enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public final <T> boolean put(@ParametricNullness T object, Funnel<? super T> funnel, int numHashFunctions, LockFreeBitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= bits.set((long)combinedHash % bitSize);
            }
            return bitsChanged;
        }

        @Override
        public final <T> boolean mightContain(@ParametricNullness T object, Funnel<? super T> funnel, int numHashFunctions, LockFreeBitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                if (bits.get((long)combinedHash % bitSize)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    MURMUR128_MITZ_64{

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean put(@ParametricNullness T object, Funnel<? super T> funnel, int numHashFunctions, LockFreeBitArray bits) {
            void var1_2;
            long bitSize = bits.bitSize();
            byte[] bytes = Hashing.murmur3_128().hashObject(object, funnel).getBytesInternal();
            long hash1 = this.lowerEight(bytes);
            long hash2 = this.upperEight(bytes);
            boolean bitsChanged = false;
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                bitsChanged |= bits.set((combinedHash & Long.MAX_VALUE) % bitSize);
                combinedHash += hash2;
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean mightContain(@ParametricNullness T object, Funnel<? super T> funnel, int numHashFunctions, LockFreeBitArray bits) {
            void var2_3;
            long bitSize = bits.bitSize();
            byte[] bytes = Hashing.murmur3_128().hashObject(object, var2_3).getBytesInternal();
            long hash1 = this.lowerEight(bytes);
            long hash2 = this.upperEight(bytes);
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                if (!bits.get((combinedHash & Long.MAX_VALUE) % bitSize)) {
                    return false;
                }
                combinedHash += hash2;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private long lowerEight(byte[] bytes) {
            void var1_1;
            return Longs.fromBytes(bytes[7], bytes[6], bytes[5], bytes[4], bytes[3], bytes[2], bytes[1], (byte)var1_1[0]);
        }

        /*
         * WARNING - void declaration
         */
        private long upperEight(byte[] bytes) {
            void var1_1;
            return Longs.fromBytes(bytes[15], bytes[14], bytes[13], bytes[12], bytes[11], bytes[10], bytes[9], (byte)var1_1[8]);
        }
    };


    static final class LockFreeBitArray {
        private static final int LONG_ADDRESSABLE_BITS = 6;
        final AtomicLongArray data;
        private final LongAddable bitCount;

        /*
         * WARNING - void declaration
         */
        LockFreeBitArray(long bits) {
            void var1_1;
            Preconditions.checkArgument(bits > 0L, "data length is zero!");
            this.data = new AtomicLongArray(Ints.checkedCast(LongMath.divide((long)var1_1, 64L, RoundingMode.CEILING)));
            this.bitCount = LongAddables.create();
        }

        /*
         * WARNING - void declaration
         */
        LockFreeBitArray(long[] data) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(data.length > 0, "data length is zero!");
            this.data = new AtomicLongArray(data);
            this.bitCount = LongAddables.create();
            long bitCount = 0L;
            for (void value : var1_1) {
                bitCount += (long)Long.bitCount((long)value);
            }
            this.bitCount.add((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final boolean set(long bitIndex) {
            long newValue;
            long oldValue;
            void var1_1;
            if (this.get(bitIndex)) {
                return false;
            }
            int longIndex = (int)(bitIndex >>> 6);
            long mask = 1L << (int)var1_1;
            do {
                if ((oldValue = this.data.get(longIndex)) != (newValue = oldValue | mask)) continue;
                return false;
            } while (!this.data.compareAndSet(longIndex, oldValue, newValue));
            this.bitCount.increment();
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final boolean get(long bitIndex) {
            void var1_1;
            return (this.data.get((int)(bitIndex >>> 6)) & 1L << (int)var1_1) != 0L;
        }

        /*
         * WARNING - void declaration
         */
        public static long[] toPlainArray(AtomicLongArray atomicLongArray) {
            void var1_1;
            long[] array = new long[atomicLongArray.length()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = atomicLongArray.get(i);
            }
            return var1_1;
        }

        final long bitSize() {
            return (long)this.data.length() << 6;
        }

        final long bitCount() {
            return this.bitCount.sum();
        }

        final LockFreeBitArray copy() {
            return new LockFreeBitArray(LockFreeBitArray.toPlainArray(this.data));
        }

        final void putAll(LockFreeBitArray other) {
            Preconditions.checkArgument(this.data.length() == other.data.length(), "BitArrays must be of equal length (%s != %s)", this.data.length(), other.data.length());
            for (int i = 0; i < this.data.length(); ++i) {
                this.putData(i, other.data.get(i));
            }
        }

        /*
         * WARNING - void declaration
         */
        final void putData(int i, long longValue) {
            long ourLongNew;
            long ourLongOld;
            boolean changedAnyBits = true;
            do {
                if ((ourLongOld = this.data.get(i)) != (ourLongNew = ourLongOld | longValue)) continue;
                changedAnyBits = false;
                break;
            } while (!this.data.compareAndSet(i, ourLongOld, ourLongNew));
            if (changedAnyBits) {
                void var1_1;
                int bitsAdded = Long.bitCount(ourLongNew) - Long.bitCount(ourLongOld);
                this.bitCount.add((long)var1_1);
            }
        }

        final int dataLength() {
            return this.data.length();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            if (o instanceof LockFreeBitArray) {
                void var1_1;
                LockFreeBitArray lockFreeBitArray = (LockFreeBitArray)o;
                return Arrays.equals(LockFreeBitArray.toPlainArray(this.data), LockFreeBitArray.toPlainArray(var1_1.data));
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(LockFreeBitArray.toPlainArray(this.data));
        }
    }
}

