/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.ParametricNullness;
import com.google.common.math.DoubleMath;
import com.google.common.math.LongMath;
import com.google.common.primitives.SignedBytes;
import com.google.common.primitives.UnsignedBytes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@Beta
public final class BloomFilter<T>
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.LockFreeBitArray bits;
    private final int numHashFunctions;
    private final Funnel<? super T> funnel;
    private final Strategy strategy;

    /*
     * WARNING - void declaration
     */
    private BloomFilter(BloomFilterStrategies.LockFreeBitArray bits, int numHashFunctions, Funnel<? super T> funnel, Strategy strategy) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(numHashFunctions > 0, "numHashFunctions (%s) must be > 0", numHashFunctions);
        Preconditions.checkArgument(numHashFunctions <= 255, "numHashFunctions (%s) must be <= 255", numHashFunctions);
        this.bits = (BloomFilterStrategies.LockFreeBitArray)Preconditions.checkNotNull(var1_1);
        this.numHashFunctions = var2_2;
        this.funnel = (Funnel)Preconditions.checkNotNull(var3_3);
        this.strategy = Preconditions.checkNotNull(strategy);
    }

    public final BloomFilter<T> copy() {
        return new BloomFilter<T>(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean mightContain(@ParametricNullness T object) {
        void var1_1;
        return this.strategy.mightContain(var1_1, this.funnel, this.numHashFunctions, this.bits);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final boolean apply(@ParametricNullness T input) {
        void var1_1;
        return this.mightContain(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean put(@ParametricNullness T object) {
        void var1_1;
        return this.strategy.put(var1_1, this.funnel, this.numHashFunctions, this.bits);
    }

    public final double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    /*
     * WARNING - void declaration
     */
    public final long approximateElementCount() {
        void var1_1;
        long bitSize = this.bits.bitSize();
        long l = this.bits.bitCount();
        double d = (double)l / (double)bitSize;
        return DoubleMath.roundToLong(-Math.log1p(-d) * (double)var1_1 / (double)this.numHashFunctions, RoundingMode.HALF_UP);
    }

    @VisibleForTesting
    final long bitSize() {
        return this.bits.bitSize();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompatible(BloomFilter<T> that) {
        void var1_1;
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(var1_1.funnel);
    }

    /*
     * WARNING - void declaration
     */
    public final void putAll(BloomFilter<T> that) {
        void var1_1;
        Preconditions.checkNotNull(that);
        Preconditions.checkArgument(this != that, "Cannot combine a BloomFilter with itself.");
        Preconditions.checkArgument(this.numHashFunctions == that.numHashFunctions, "BloomFilters must have the same number of hash functions (%s != %s)", this.numHashFunctions, that.numHashFunctions);
        Preconditions.checkArgument(this.bitSize() == that.bitSize(), "BloomFilters must have the same size underlying bit arrays (%s != %s)", this.bitSize(), that.bitSize());
        Preconditions.checkArgument(this.strategy.equals(that.strategy), "BloomFilters must have equal strategies (%s != %s)", (Object)this.strategy, (Object)that.strategy);
        Preconditions.checkArgument(this.funnel.equals(that.funnel), "BloomFilters must have equal funnels (%s != %s)", this.funnel, that.funnel);
        this.bits.putAll(var1_1.bits);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            void var1_1;
            BloomFilter that = (BloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.funnel.equals(that.funnel) && this.bits.equals(that.bits) && this.strategy.equals(var1_1.strategy);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.numHashFunctions, this.funnel, this.strategy, this.bits);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions) {
        void var1_1;
        return BloomFilter.toBloomFilter(funnel, (long)var1_1, 0.03);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        void var3_2;
        void var1_1;
        Funnel<? super T> funnel2;
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions >= 0L, "Expected insertions (%s) must be >= 0", expectedInsertions);
        Preconditions.checkArgument(fpp > 0.0, "False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument(fpp < 1.0, "False positive probability (%s) must be < 1.0", (Object)fpp);
        return Collector.of(() -> BloomFilter.lambda$toBloomFilter$0(funnel2, (long)var1_1, (double)var3_2), BloomFilter::put, (bf1, bf2) -> {
            BloomFilter bloomFilter;
            void var1_1;
            bf1.putAll((BloomFilter)var1_1);
            return bloomFilter;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions, double fpp) {
        void var2_2;
        void var1_1;
        return BloomFilter.create(funnel, (long)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        void var3_2;
        void var1_1;
        return BloomFilter.create(funnel, (long)var1_1, (double)var3_2, BloomFilterStrategies.MURMUR128_MITZ_64);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, Strategy strategy) {
        void var3_4;
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions >= 0L, "Expected insertions (%s) must be >= 0", expectedInsertions);
        Preconditions.checkArgument(fpp > 0.0, "False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument(fpp < 1.0, "False positive probability (%s) must be < 1.0", (Object)fpp);
        Preconditions.checkNotNull(strategy);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = BloomFilter.optimalNumOfBits(expectedInsertions, (double)var3_4);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        try {
            void var1_3;
            return new BloomFilter<T>(new BloomFilterStrategies.LockFreeBitArray(numBits), (int)var1_3, funnel, strategy);
        }
        catch (IllegalArgumentException e) {
            void var0_1;
            throw new IllegalArgumentException(new StringBuilder(57).append("Could not create BloomFilter of ").append(numBits).append(" bits").toString(), (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions) {
        void var1_1;
        return BloomFilter.create(funnel, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions) {
        void var1_1;
        return BloomFilter.create(funnel, (long)var1_1, 0.03);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m) {
        long l;
        void var2_1;
        return Math.max(1, (int)Math.round((double)var2_1 / (double)l * Math.log(2.0)));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        void var2_1;
        long l;
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-l) * Math.log((double)var2_1) / (Math.log(2.0) * Math.log(2.0)));
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    public final void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte(SignedBytes.checkedCast(this.strategy.ordinal()));
        dout.writeByte(UnsignedBytes.checkedCast(this.numHashFunctions));
        dout.writeInt(this.bits.data.length());
        for (int i = 0; i < this.bits.data.length(); ++i) {
            dout.writeLong(this.bits.data.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BloomFilter<T> readFrom(InputStream in, Funnel<? super T> funnel) throws IOException {
        Preconditions.checkNotNull(in, "InputStream");
        Preconditions.checkNotNull(funnel, "Funnel");
        int strategyOrdinal = -1;
        int numHashFunctions = -1;
        int dataLength = -1;
        try {
            void var1_2;
            InputStream din = new DataInputStream(in);
            strategyOrdinal = ((DataInputStream)din).readByte();
            numHashFunctions = UnsignedBytes.toInt(((DataInputStream)din).readByte());
            dataLength = ((DataInputStream)din).readInt();
            BloomFilterStrategies strategy = BloomFilterStrategies.values()[strategyOrdinal];
            BloomFilterStrategies.LockFreeBitArray dataArray = new BloomFilterStrategies.LockFreeBitArray(LongMath.checkedMultiply(dataLength, 64L));
            for (int i = 0; i < dataLength; ++i) {
                dataArray.putData(i, ((DataInputStream)din).readLong());
            }
            return new BloomFilter<T>(dataArray, numHashFunctions, var1_2, strategy);
        }
        catch (RuntimeException e) {
            void var0_1;
            void var3_5;
            void var2_4;
            void var6_10 = var2_4;
            void var7_12 = var3_5;
            int n = dataLength;
            String message = new StringBuilder(134).append("Unable to deserialize BloomFilter from InputStream. strategyOrdinal: ").append((int)var6_10).append(" numHashFunctions: ").append((int)var7_12).append(" dataLength: ").append(n).toString();
            throw new IOException(message, (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ BloomFilter lambda$toBloomFilter$0(Funnel funnel, long expectedInsertions, double fpp) {
        void var3_2;
        void var1_1;
        return BloomFilter.create(funnel, (long)var1_1, (double)var3_2);
    }

    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<? super T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        SerialForm(BloomFilter<T> bf) {
            void var1_1;
            this.data = BloomFilterStrategies.LockFreeBitArray.toPlainArray(((BloomFilter)bf).bits.data);
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.strategy = ((BloomFilter)var1_1).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.LockFreeBitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    static interface Strategy
    extends Serializable {
        public <T> boolean put(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public <T> boolean mightContain(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public int ordinal();
    }
}

