/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@ElementTypesAreNonnullByDefault
abstract class AbstractStreamingHasher
extends AbstractHasher {
    private final ByteBuffer buffer;
    private final int bufferSize;
    private final int chunkSize;

    /*
     * WARNING - void declaration
     */
    protected AbstractStreamingHasher(int chunkSize) {
        void var1_1;
        void v0 = var1_1;
        this((int)v0, (int)v0);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractStreamingHasher(int chunkSize, int bufferSize) {
        void var1_1;
        void var2_2;
        Preconditions.checkArgument(bufferSize % chunkSize == 0);
        this.buffer = ByteBuffer.allocate(bufferSize + 7).order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSize = var2_2;
        this.chunkSize = var1_1;
    }

    protected abstract void process(ByteBuffer var1);

    /*
     * WARNING - void declaration
     */
    protected void processRemaining(ByteBuffer bb) {
        void var1_1;
        ByteBuffer byteBuffer = bb;
        Java8Compatibility.position(byteBuffer, byteBuffer.limit());
        Java8Compatibility.limit(bb, this.chunkSize + 7);
        while (bb.position() < this.chunkSize) {
            bb.putLong(0L);
        }
        Java8Compatibility.limit(bb, this.chunkSize);
        Java8Compatibility.flip(bb);
        this.process((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putBytes(byte[] bytes, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putBytesInternal(ByteBuffer.wrap((byte[])var1_1, (int)var2_2, (int)var3_3).order(ByteOrder.LITTLE_ENDIAN));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putBytes(ByteBuffer readBuffer) {
        Hasher hasher;
        ByteOrder order = readBuffer.order();
        try {
            readBuffer.order(ByteOrder.LITTLE_ENDIAN);
            hasher = this.putBytesInternal(readBuffer);
            readBuffer.order(order);
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            var1_1.order((ByteOrder)var2_2);
            throw throwable;
        }
        return hasher;
    }

    /*
     * WARNING - void declaration
     */
    private Hasher putBytesInternal(ByteBuffer readBuffer) {
        void var1_1;
        if (readBuffer.remaining() <= this.buffer.remaining()) {
            this.buffer.put(readBuffer);
            this.munchIfFull();
            return this;
        }
        int bytesToCopy = this.bufferSize - this.buffer.position();
        for (int i = 0; i < bytesToCopy; ++i) {
            this.buffer.put(readBuffer.get());
        }
        this.munch();
        while (readBuffer.remaining() >= this.chunkSize) {
            this.process(readBuffer);
        }
        this.buffer.put((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putByte(byte b) {
        void var1_1;
        this.buffer.put((byte)var1_1);
        this.munchIfFull();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putShort(short s) {
        void var1_1;
        this.buffer.putShort((short)var1_1);
        this.munchIfFull();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putChar(char c) {
        void var1_1;
        this.buffer.putChar((char)var1_1);
        this.munchIfFull();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putInt(int i) {
        void var1_1;
        this.buffer.putInt((int)var1_1);
        this.munchIfFull();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putLong(long l) {
        void var1_1;
        this.buffer.putLong((long)var1_1);
        this.munchIfFull();
        return this;
    }

    @Override
    public final HashCode hash() {
        this.munch();
        Java8Compatibility.flip(this.buffer);
        if (this.buffer.remaining() > 0) {
            AbstractStreamingHasher abstractStreamingHasher = this;
            abstractStreamingHasher.processRemaining(abstractStreamingHasher.buffer);
            Java8Compatibility.position(this.buffer, this.buffer.limit());
        }
        return this.makeHash();
    }

    protected abstract HashCode makeHash();

    private void munchIfFull() {
        if (this.buffer.remaining() < 8) {
            this.munch();
        }
    }

    private void munch() {
        Java8Compatibility.flip(this.buffer);
        while (this.buffer.remaining() >= this.chunkSize) {
            AbstractStreamingHasher abstractStreamingHasher = this;
            abstractStreamingHasher.process(abstractStreamingHasher.buffer);
        }
        this.buffer.compact();
    }
}

