/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

@ElementTypesAreNonnullByDefault
abstract class AbstractNonStreamingHashFunction
extends AbstractHashFunction {
    AbstractNonStreamingHashFunction() {
    }

    @Override
    public Hasher newHasher() {
        return this.newHasher(32);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher newHasher(int expectedInputSize) {
        void var1_1;
        Preconditions.checkArgument(expectedInputSize >= 0);
        return new BufferingHasher((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashInt(int input) {
        void var1_1;
        return this.hashBytes(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt((int)var1_1).array());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashLong(long input) {
        void var1_1;
        return this.hashBytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong((long)var1_1).array());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        void var3_3;
        int len = input.length();
        ByteBuffer buffer = ByteBuffer.allocate(len << 1).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < len; ++i) {
            buffer.putChar(input.charAt(i));
        }
        return this.hashBytes(var3_3.array());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        void var2_2;
        void var1_1;
        return this.hashBytes(var1_1.toString().getBytes((Charset)var2_2));
    }

    @Override
    public abstract HashCode hashBytes(byte[] var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashBytes(ByteBuffer input) {
        void var1_1;
        return this.newHasher(input.remaining()).putBytes((ByteBuffer)var1_1).hash();
    }

    private static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        /*
         * WARNING - void declaration
         */
        ExposedByteArrayOutputStream(int expectedInputSize) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void write(ByteBuffer input) {
            void var2_2;
            void var1_1;
            int remaining = input.remaining();
            if (this.count + remaining > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.count + remaining);
            }
            var1_1.get(this.buf, this.count, remaining);
            this.count += var2_2;
        }

        final byte[] byteArray() {
            return this.buf;
        }

        final int length() {
            return this.count;
        }
    }

    private final class BufferingHasher
    extends AbstractHasher {
        final ExposedByteArrayOutputStream stream;

        /*
         * WARNING - void declaration
         */
        BufferingHasher(int expectedInputSize) {
            void var2_2;
            this.stream = new ExposedByteArrayOutputStream((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putByte(byte b) {
            void var1_1;
            this.stream.write((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putBytes(byte[] bytes, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.stream.write((byte[])var1_1, (int)var2_2, (int)var3_3);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Hasher putBytes(ByteBuffer bytes) {
            void var1_1;
            this.stream.write((ByteBuffer)var1_1);
            return this;
        }

        @Override
        public final HashCode hash() {
            return AbstractNonStreamingHashFunction.this.hashBytes(this.stream.byteArray(), 0, this.stream.length());
        }
    }
}

