/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putBoolean(boolean b) {
        void var1_1;
        return this.putByte(var1_1 != false ? (byte)1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putDouble(double d) {
        void var1_1;
        return this.putLong(Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Hasher putFloat(float f) {
        void var1_1;
        return this.putInt(Float.floatToRawIntBits((float)var1_1));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i = 0; i < len; ++i) {
            this.putChar(charSequence.charAt(i));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        void var2_2;
        void var1_1;
        return this.putBytes(var1_1.toString().getBytes((Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putBytes(byte[] bytes) {
        void var1_1;
        return this.putBytes(bytes, 0, ((void)var1_1).length);
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, bytes.length);
        for (int i = 0; i < len; ++i) {
            this.putByte(bytes[off + i]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b) {
        if (b.hasArray()) {
            this.putBytes(b.array(), b.arrayOffset() + b.position(), b.remaining());
            ByteBuffer byteBuffer = b;
            Java8Compatibility.position(byteBuffer, byteBuffer.limit());
        } else {
            for (int remaining = b.remaining(); remaining > 0; --remaining) {
                this.putByte(b.get());
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putShort(short s) {
        void var1_1;
        this.putByte((byte)s);
        this.putByte((byte)(var1_1 >>> 8));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putInt(int i) {
        void var1_1;
        this.putByte((byte)i);
        this.putByte((byte)(i >>> 8));
        this.putByte((byte)(i >>> 16));
        this.putByte((byte)(var1_1 >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l) {
        for (int i = 0; i < 64; i += 8) {
            this.putByte((byte)(l >>> i));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putChar(char c) {
        void var1_1;
        this.putByte((byte)c);
        this.putByte((byte)(var1_1 >>> 8));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        void var1_1;
        funnel.funnel(var1_1, this);
        return this;
    }
}

