/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.ParametricNullness;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
abstract class AbstractHashFunction
implements HashFunction {
    AbstractHashFunction() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> HashCode hashObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        void var2_2;
        void var1_1;
        return this.newHasher().putObject(var1_1, var2_2).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        void var1_1;
        void var2_2;
        int len = input.length();
        return this.newHasher((int)(var2_2 << 1)).putUnencodedChars((CharSequence)var1_1).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        void var2_2;
        void var1_1;
        return this.newHasher().putString((CharSequence)var1_1, (Charset)var2_2).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashInt(int input) {
        void var1_1;
        return this.newHasher(4).putInt((int)var1_1).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashLong(long input) {
        void var1_1;
        return this.newHasher(8).putLong((long)var1_1).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashBytes(byte[] input) {
        void var1_1;
        return this.hashBytes(input, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, input.length);
        return this.newHasher(len).putBytes((byte[])var1_1, (int)var2_2, (int)var3_3).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashCode hashBytes(ByteBuffer input) {
        void var1_1;
        return this.newHasher(input.remaining()).putBytes((ByteBuffer)var1_1).hash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher newHasher(int expectedInputSize) {
        void var1_1;
        Preconditions.checkArgument(expectedInputSize >= 0, "expectedInputSize must be >= 0 but was %s", (int)var1_1);
        return this.newHasher();
    }
}

