/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    AbstractCompositeHashFunction(HashFunction ... functions) {
        void var1_1;
        HashFunction[] hashFunctionArray = functions;
        int n = functions.length;
        for (int i = 0; i < n; ++i) {
            HashFunction hashFunction = hashFunctionArray[i];
            Preconditions.checkNotNull(hashFunction);
        }
        this.functions = var1_1;
    }

    abstract HashCode makeHash(Hasher[] var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher newHasher() {
        void var1_1;
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i = 0; i < hashers.length; ++i) {
            hashers[i] = this.functions[i].newHasher();
        }
        return this.fromHashers((Hasher[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher newHasher(int expectedInputSize) {
        void var2_2;
        Preconditions.checkArgument(expectedInputSize >= 0);
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i = 0; i < hashers.length; ++i) {
            hashers[i] = this.functions[i].newHasher(expectedInputSize);
        }
        return this.fromHashers((Hasher[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Hasher fromHashers(Hasher[] hashers) {
        void var1_1;
        return new Hasher(this, (Hasher[])var1_1){
            final /* synthetic */ Hasher[] val$hashers;
            final /* synthetic */ AbstractCompositeHashFunction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$hashers = hasherArray;
            }

            @Override
            public Hasher putByte(byte b) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putByte(b);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putBytes(bytes);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes, int off, int len) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putBytes(bytes, off, len);
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer bytes) {
                int pos = bytes.position();
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    Java8Compatibility.position(bytes, pos);
                    hasher.putBytes(bytes);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putShort(s);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int j = 0; j < n; ++j) {
                    Hasher hasher = hasherArray[j];
                    hasher.putInt(i);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putLong(l);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putFloat(f);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putDouble(d);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putBoolean(b);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putChar(c);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putUnencodedChars(chars);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars, Charset charset) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putString(chars, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
                Hasher[] hasherArray = this.val$hashers;
                int n = this.val$hashers.length;
                for (int i = 0; i < n; ++i) {
                    Hasher hasher = hasherArray[i];
                    hasher.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return this.this$0.makeHash(this.val$hashers);
            }
        };
    }
}

