/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@ElementTypesAreNonnullByDefault
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    /*
     * WARNING - void declaration
     */
    protected void update(byte[] b) {
        void var1_1;
        this.update(b, 0, ((void)var1_1).length);
    }

    protected void update(byte[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.update(b[i]);
        }
    }

    protected void update(ByteBuffer b) {
        if (b.hasArray()) {
            this.update(b.array(), b.arrayOffset() + b.position(), b.remaining());
            ByteBuffer byteBuffer = b;
            Java8Compatibility.position(byteBuffer, byteBuffer.limit());
            return;
        }
        for (int remaining = b.remaining(); remaining > 0; --remaining) {
            this.update(b.get());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Hasher update(int bytes) {
        try {
            void var1_1;
            AbstractByteHasher abstractByteHasher = this;
            abstractByteHasher.update(abstractByteHasher.scratch.array(), 0, (int)var1_1);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putByte(byte b) {
        void var1_1;
        this.update((byte)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putBytes(byte[] bytes) {
        void var1_1;
        Preconditions.checkNotNull(bytes);
        this.update((byte[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, bytes.length);
        this.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putBytes(ByteBuffer bytes) {
        void var1_1;
        this.update((ByteBuffer)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putShort(short s) {
        void var1_1;
        this.scratch.putShort((short)var1_1);
        return this.update(2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putInt(int i) {
        void var1_1;
        this.scratch.putInt((int)var1_1);
        return this.update(4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putLong(long l) {
        void var1_1;
        this.scratch.putLong((long)var1_1);
        return this.update(8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Hasher putChar(char c) {
        void var1_1;
        this.scratch.putChar((char)var1_1);
        return this.update(2);
    }
}

