/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardMutableValueGraph;
import com.google.common.graph.ValueGraph;

@ElementTypesAreNonnullByDefault
@Beta
public final class ValueGraphBuilder<N, V>
extends AbstractGraphBuilder<N> {
    /*
     * WARNING - void declaration
     */
    private ValueGraphBuilder(boolean directed) {
        super((boolean)var1_1);
        void var1_1;
    }

    public static ValueGraphBuilder<Object, Object> directed() {
        return new ValueGraphBuilder<Object, Object>(true);
    }

    public static ValueGraphBuilder<Object, Object> undirected() {
        return new ValueGraphBuilder<Object, Object>(false);
    }

    public static <N, V> ValueGraphBuilder<N, V> from(ValueGraph<N, V> graph) {
        ValueGraph<N, V> valueGraph;
        return new ValueGraphBuilder<N, V>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder()).incidentEdgeOrder(valueGraph.incidentEdgeOrder());
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N, V1 extends V> ImmutableValueGraph.Builder<N1, V1> immutable() {
        void var1_1;
        ValueGraphBuilder<N1, V1> castBuilder = this.cast();
        return new ImmutableValueGraph.Builder(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ValueGraphBuilder<N, V> allowsSelfLoops(boolean allowsSelfLoops) {
        void var1_1;
        this.allowsSelfLoops = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ValueGraphBuilder<N, V> expectedNodeCount(int expectedNodeCount) {
        void var1_1;
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> ValueGraphBuilder<N1, V> nodeOrder(ElementOrder<N1> nodeOrder) {
        void var2_2;
        void var1_1;
        ValueGraphBuilder newBuilder = this.cast();
        this.cast().nodeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> ValueGraphBuilder<N1, V> incidentEdgeOrder(ElementOrder<N1> incidentEdgeOrder) {
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(incidentEdgeOrder.type() == ElementOrder.Type.UNORDERED || incidentEdgeOrder.type() == ElementOrder.Type.STABLE, "The given elementOrder (%s) is unsupported. incidentEdgeOrder() only supports ElementOrder.unordered() and ElementOrder.stable().", incidentEdgeOrder);
        ValueGraphBuilder newBuilder = this.cast();
        this.cast().incidentEdgeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    public final <N1 extends N, V1 extends V> MutableValueGraph<N1, V1> build() {
        return new StandardMutableValueGraph(this);
    }

    /*
     * WARNING - void declaration
     */
    final ValueGraphBuilder<N, V> copy() {
        void var1_1;
        ValueGraphBuilder<N, V> newBuilder = new ValueGraphBuilder<N, V>(this.directed);
        new ValueGraphBuilder<N, V>(this.directed).allowsSelfLoops = this.allowsSelfLoops;
        newBuilder.nodeOrder = this.nodeOrder;
        newBuilder.expectedNodeCount = this.expectedNodeCount;
        newBuilder.incidentEdgeOrder = this.incidentEdgeOrder;
        return var1_1;
    }

    private <N1 extends N, V1 extends V> ValueGraphBuilder<N1, V1> cast() {
        return this;
    }
}

