/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.graph.AbstractUndirectedNetworkConnections;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.MultiEdgesConnecting;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class UndirectedMultiNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    private transient Reference<Multiset<N>> adjacentNodesReference;

    /*
     * WARNING - void declaration
     */
    private UndirectedMultiNetworkConnections(Map<E, N> incidentEdges) {
        super(var1_1);
        void var1_1;
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> of() {
        return new UndirectedMultiNetworkConnections(new HashMap(2, 1.0f));
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        Map<E, N> map;
        return new UndirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(map));
    }

    @Override
    public final Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodesMultiset().elementSet());
    }

    /*
     * WARNING - void declaration
     */
    private Multiset<N> adjacentNodesMultiset() {
        void var1_1;
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes == null) {
            adjacentNodes = HashMultiset.create(this.incidentEdgeMap.values());
            this.adjacentNodesReference = new SoftReference<Multiset<N>>(adjacentNodes);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<E> edgesConnecting(N node) {
        void var1_1;
        UndirectedMultiNetworkConnections undirectedMultiNetworkConnections = this;
        void v1 = var1_1;
        return new MultiEdgesConnecting<E>(undirectedMultiNetworkConnections, undirectedMultiNetworkConnections.incidentEdgeMap, v1, v1){
            final /* synthetic */ Object val$node;
            final /* synthetic */ UndirectedMultiNetworkConnections this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$node = object;
                super(var2_2, var3_3);
            }

            @Override
            public int size() {
                return this.this$0.adjacentNodesMultiset().count(this.val$node);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final N removeInEdge(E edge, boolean isSelfLoop) {
        if (!isSelfLoop) {
            void var1_1;
            return this.removeOutEdge(var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final N removeOutEdge(E edge) {
        void var1_1;
        Object node = super.removeOutEdge(edge);
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes != null) {
            void var2_2;
            Preconditions.checkState(var2_2.remove(node));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addInEdge(E edge, N node, boolean isSelfLoop) {
        if (!isSelfLoop) {
            void var2_2;
            void var1_1;
            this.addOutEdge(var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addOutEdge(E edge, N node) {
        super.addOutEdge(edge, node);
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes != null) {
            void var2_2;
            void var1_1;
            Preconditions.checkState(var1_1.add(var2_2));
        }
    }

    private static <T> T getReference(Reference<T> reference) {
        Reference<T> reference2;
        if (reference == null) {
            return null;
        }
        return reference2.get();
    }
}

