/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class UndirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private final Map<N, V> adjacentNodeValues;

    /*
     * WARNING - void declaration
     */
    private UndirectedGraphConnections(Map<N, V> adjacentNodeValues) {
        void var1_1;
        this.adjacentNodeValues = (Map)Preconditions.checkNotNull(var1_1);
    }

    static <N, V> UndirectedGraphConnections<N, V> of(ElementOrder<N> incidentEdgeOrder) {
        ElementOrder<N> elementOrder;
        switch (incidentEdgeOrder.type()) {
            case UNORDERED: {
                return new UndirectedGraphConnections(new HashMap(2, 1.0f));
            }
            case STABLE: {
                return new UndirectedGraphConnections(new LinkedHashMap(2, 1.0f));
            }
        }
        throw new AssertionError((Object)elementOrder.type());
    }

    static <N, V> UndirectedGraphConnections<N, V> ofImmutable(Map<N, V> adjacentNodeValues) {
        Map<N, V> map;
        return new UndirectedGraphConnections<N, V>(ImmutableMap.copyOf(map));
    }

    @Override
    public final Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public final Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public final Set<N> successors() {
        return this.adjacentNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<EndpointPair<N>> incidentEdgeIterator(N thisNode) {
        void var1_1;
        return Iterators.transform(this.adjacentNodeValues.keySet().iterator(), incidentNode -> {
            void var1_1;
            return EndpointPair.unordered(var1_1, var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V value(N node) {
        void var1_1;
        return this.adjacentNodeValues.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removePredecessor(N node) {
        void var1_1;
        this.removeSuccessor(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V removeSuccessor(N node) {
        void var1_1;
        return this.adjacentNodeValues.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addPredecessor(N node, V value) {
        void var2_2;
        void var1_1;
        this.addSuccessor(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V addSuccessor(N node, V value) {
        void var2_2;
        void var1_1;
        return this.adjacentNodeValues.put(var1_1, var2_2);
    }
}

