/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Network;
import com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class Traverser<N> {
    private final SuccessorsFunction<N> successorFunction;

    /*
     * WARNING - void declaration
     */
    private Traverser(SuccessorsFunction<N> successorFunction) {
        void var1_1;
        this.successorFunction = (SuccessorsFunction)Preconditions.checkNotNull(var1_1);
    }

    public static <N> Traverser<N> forGraph(SuccessorsFunction<N> graph) {
        SuccessorsFunction<N> successorsFunction;
        final SuccessorsFunction<N> successorsFunction2 = successorsFunction;
        return new Traverser<N>(successorsFunction2){
            {
                void var1_1;
                super((SuccessorsFunction)var1_1);
            }

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inGraph(successorsFunction2);
            }
        };
    }

    public static <N> Traverser<N> forTree(SuccessorsFunction<N> tree) {
        SuccessorsFunction<N> successorsFunction;
        if (tree instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)tree).isDirected(), "Undirected graphs can never be trees.");
        }
        if (tree instanceof Network) {
            Preconditions.checkArgument(((Network)tree).isDirected(), "Undirected networks can never be trees.");
        }
        final SuccessorsFunction<N> successorsFunction2 = successorsFunction;
        return new Traverser<N>(successorsFunction2){
            {
                void var1_1;
                super((SuccessorsFunction)var1_1);
            }

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inTree(successorsFunction2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> breadthFirst(N startNode) {
        void var1_1;
        return this.breadthFirst((Iterable<? extends N>)ImmutableSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> breadthFirst(Iterable<? extends N> startNodes) {
        void var1_1;
        ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(this, (ImmutableSet)var1_1){
            final /* synthetic */ ImmutableSet val$validated;
            final /* synthetic */ Traverser this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$validated = immutableSet;
            }

            @Override
            public Iterator<N> iterator() {
                return this.this$0.newTraversal().breadthFirst(((ImmutableCollection)this.val$validated).iterator());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> depthFirstPreOrder(N startNode) {
        void var1_1;
        return this.depthFirstPreOrder((Iterable<? extends N>)ImmutableSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> depthFirstPreOrder(Iterable<? extends N> startNodes) {
        void var1_1;
        ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(this, (ImmutableSet)var1_1){
            final /* synthetic */ ImmutableSet val$validated;
            final /* synthetic */ Traverser this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$validated = immutableSet;
            }

            @Override
            public Iterator<N> iterator() {
                return this.this$0.newTraversal().preOrder(((ImmutableCollection)this.val$validated).iterator());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> depthFirstPostOrder(N startNode) {
        void var1_1;
        return this.depthFirstPostOrder((Iterable<? extends N>)ImmutableSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<N> depthFirstPostOrder(Iterable<? extends N> startNodes) {
        void var1_1;
        ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(this, (ImmutableSet)var1_1){
            final /* synthetic */ ImmutableSet val$validated;
            final /* synthetic */ Traverser this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$validated = immutableSet;
            }

            @Override
            public Iterator<N> iterator() {
                return this.this$0.newTraversal().postOrder(((ImmutableCollection)this.val$validated).iterator());
            }
        };
    }

    abstract Traversal<N> newTraversal();

    /*
     * WARNING - void declaration
     */
    private ImmutableSet<N> validate(Iterable<? extends N> startNodes) {
        void var1_1;
        ImmutableSet copy = ImmutableSet.copyOf(startNodes);
        for (Object node : copy) {
            void var3_3;
            this.successorFunction.successors(var3_3);
        }
        return var1_1;
    }

    private static enum InsertionOrder {
        FRONT{

            /*
             * WARNING - void declaration
             */
            @Override
            final <T> void insertInto(Deque<T> deque, T value) {
                void var2_2;
                deque.addFirst(var2_2);
            }
        }
        ,
        BACK{

            /*
             * WARNING - void declaration
             */
            @Override
            final <T> void insertInto(Deque<T> deque, T value) {
                void var2_2;
                deque.addLast(var2_2);
            }
        };


        abstract <T> void insertInto(Deque<T> var1, T var2);
    }

    private static abstract class Traversal<N> {
        final SuccessorsFunction<N> successorFunction;

        /*
         * WARNING - void declaration
         */
        Traversal(SuccessorsFunction<N> successorFunction) {
            void var1_1;
            this.successorFunction = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static <N> Traversal<N> inGraph(SuccessorsFunction<N> graph) {
            void var1_1;
            SuccessorsFunction<N> successorsFunction;
            HashSet visited = new HashSet();
            return new Traversal<N>(successorsFunction, (Set)var1_1){
                final /* synthetic */ Set val$visited;
                {
                    void var1_1;
                    this.val$visited = set;
                    super(var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                N visitNext(Deque<Iterator<? extends N>> horizon) {
                    void var1_1;
                    Iterator top = horizon.getFirst();
                    while (top.hasNext()) {
                        void var3_3;
                        Object element = top.next();
                        Objects.requireNonNull(element);
                        if (!this.val$visited.add(element)) continue;
                        return var3_3;
                    }
                    var1_1.removeFirst();
                    return null;
                }
            };
        }

        static <N> Traversal<N> inTree(SuccessorsFunction<N> tree) {
            SuccessorsFunction<N> successorsFunction;
            return new Traversal<N>((SuccessorsFunction)successorsFunction){
                {
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                N visitNext(Deque<Iterator<? extends N>> horizon) {
                    void var1_1;
                    Iterator top = horizon.getFirst();
                    if (top.hasNext()) {
                        void var2_2;
                        return Preconditions.checkNotNull(var2_2.next());
                    }
                    var1_1.removeFirst();
                    return null;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        final Iterator<N> breadthFirst(Iterator<? extends N> startNodes) {
            void var1_1;
            return this.topDown((Iterator<? extends N>)var1_1, InsertionOrder.BACK);
        }

        /*
         * WARNING - void declaration
         */
        final Iterator<N> preOrder(Iterator<? extends N> startNodes) {
            void var1_1;
            return this.topDown((Iterator<? extends N>)var1_1, InsertionOrder.FRONT);
        }

        /*
         * WARNING - void declaration
         */
        private Iterator<N> topDown(Iterator<? extends N> startNodes, InsertionOrder order) {
            void var2_2;
            void var3_3;
            void var1_1;
            ArrayDeque<void> horizon = new ArrayDeque<void>();
            horizon.add(var1_1);
            return new AbstractIterator<N>(this, (Deque)var3_3, (InsertionOrder)var2_2){
                final /* synthetic */ Deque val$horizon;
                final /* synthetic */ InsertionOrder val$order;
                final /* synthetic */ Traversal this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$horizon = deque;
                    this.val$order = insertionOrder;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected N computeNext() {
                    do {
                        void var1_1;
                        Object next;
                        if ((next = this.this$0.visitNext(this.val$horizon)) == null) continue;
                        Iterator successors = this.this$0.successorFunction.successors(next).iterator();
                        if (successors.hasNext()) {
                            void var2_2;
                            this.val$order.insertInto(this.val$horizon, var2_2);
                        }
                        return var1_1;
                    } while (!this.val$horizon.isEmpty());
                    return this.endOfData();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        final Iterator<N> postOrder(Iterator<? extends N> startNodes) {
            void var2_2;
            void var3_3;
            void var1_1;
            ArrayDeque ancestorStack = new ArrayDeque();
            ArrayDeque<void> horizon = new ArrayDeque<void>();
            horizon.add(var1_1);
            return new AbstractIterator<N>(this, (Deque)var3_3, (Deque)var2_2){
                final /* synthetic */ Deque val$horizon;
                final /* synthetic */ Deque val$ancestorStack;
                final /* synthetic */ Traversal this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$horizon = deque;
                    this.val$ancestorStack = deque2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected N computeNext() {
                    Object next = this.this$0.visitNext(this.val$horizon);
                    while (next != null) {
                        void var2_2;
                        Iterator successors = this.this$0.successorFunction.successors(next).iterator();
                        if (!successors.hasNext()) {
                            return next;
                        }
                        this.val$horizon.addFirst(var2_2);
                        this.val$ancestorStack.push(next);
                        next = this.this$0.visitNext(this.val$horizon);
                    }
                    if (!this.val$ancestorStack.isEmpty()) {
                        return this.val$ancestorStack.pop();
                    }
                    return this.endOfData();
                }
            };
        }

        abstract N visitNext(Deque<Iterator<? extends N>> var1);
    }
}

