/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
class StandardValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    private final boolean isDirected;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    final MapIteratorCache<N, GraphConnections<N, V>> nodeConnections;
    long edgeCount;

    /*
     * WARNING - void declaration
     */
    StandardValueGraph(AbstractGraphBuilder<? super N> builder) {
        void var1_1;
        AbstractGraphBuilder<? super N> abstractGraphBuilder = builder;
        this(abstractGraphBuilder, abstractGraphBuilder.nodeOrder.createMap(var1_1.expectedNodeCount.or(10)), 0L);
    }

    /*
     * WARNING - void declaration
     */
    StandardValueGraph(AbstractGraphBuilder<? super N> builder, Map<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isDirected = builder.directed;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeOrder = var1_1.nodeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, GraphConnections<N, V>>(nodeConnections) : new MapIteratorCache(var2_2);
        this.edgeCount = Graphs.checkNonNegative((long)var3_3);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> adjacentNodes(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).adjacentNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> predecessors(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).predecessors();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> successors(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).successors();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<EndpointPair<N>> incidentEdges(N node) {
        void var2_2;
        void var1_1;
        GraphConnections<N, V> connections = this.checkedConnections(node);
        StandardValueGraph standardValueGraph = this;
        return new IncidentEdgeSet<N>(standardValueGraph, standardValueGraph, var1_1, (GraphConnections)var2_2){
            final /* synthetic */ GraphConnections val$connections;
            {
                void var3_3;
                void var2_2;
                this.val$connections = graphConnections;
                super(var2_2, var3_3);
            }

            @Override
            public Iterator<EndpointPair<N>> iterator() {
                return this.val$connections.incidentEdgeIterator(this.node);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        return this.hasEdgeConnectingInternal(Preconditions.checkNotNull(var1_1), Preconditions.checkNotNull(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        void var1_1;
        Preconditions.checkNotNull(endpoints);
        return this.isOrderingCompatible(endpoints) && this.hasEdgeConnectingInternal(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V edgeValueOrDefault(N nodeU, N nodeV, V defaultValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.edgeValueOrDefaultInternal(Preconditions.checkNotNull(var1_1), Preconditions.checkNotNull(var2_2), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V edgeValueOrDefault(EndpointPair<N> endpoints, V defaultValue) {
        void var2_2;
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.edgeValueOrDefaultInternal(endpoints.nodeU(), var1_1.nodeV(), var2_2);
    }

    @Override
    protected long edgeCount() {
        return this.edgeCount;
    }

    /*
     * WARNING - void declaration
     */
    private final GraphConnections<N, V> checkedConnections(N node) {
        void var2_2;
        GraphConnections<N, V> connections = this.nodeConnections.get(node);
        if (connections == null) {
            String string;
            Preconditions.checkNotNull(node);
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(string).length()).append("Node ").append(string).append(" is not an element of this graph.").toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsNode(N node) {
        void var1_1;
        return this.nodeConnections.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEdgeConnectingInternal(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        GraphConnections<N, V> connectionsU = this.nodeConnections.get(nodeU);
        return connectionsU != null && var1_1.successors().contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final V edgeValueOrDefaultInternal(N nodeU, N nodeV, V defaultValue) {
        void var1_1;
        void var2_2;
        GraphConnections<N, V> connectionsU = this.nodeConnections.get(nodeU);
        Object value = connectionsU == null ? null : connectionsU.value(var2_2);
        if (value == null) {
            void var3_3;
            return var3_3;
        }
        return var1_1;
    }
}

