/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
class StandardNetwork<N, E>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    final MapIteratorCache<E, N> edgeToReferenceNode;

    /*
     * WARNING - void declaration
     */
    StandardNetwork(NetworkBuilder<? super N, ? super E> builder) {
        void var1_1;
        NetworkBuilder<? super N, ? super E> networkBuilder = builder;
        this(networkBuilder, networkBuilder.nodeOrder.createMap(builder.expectedNodeCount.or(10)), builder.edgeOrder.createMap(var1_1.expectedEdgeCount.or(20)));
    }

    /*
     * WARNING - void declaration
     */
    StandardNetwork(NetworkBuilder<? super N, ? super E> builder, Map<N, NetworkConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isDirected = builder.directed;
        this.allowsParallelEdges = builder.allowsParallelEdges;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeOrder = builder.nodeOrder.cast();
        this.edgeOrder = var1_1.edgeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(nodeConnections) : new MapIteratorCache(var2_2);
        this.edgeToReferenceNode = new MapIteratorCache(var3_3);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> incidentEdges(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).incidentEdges();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EndpointPair<N> incidentNodes(E edge) {
        void var1_1;
        void var2_2;
        N nodeU = this.checkedReferenceNode(edge);
        N nodeV = Objects.requireNonNull(this.nodeConnections.get(nodeU)).adjacentNode(edge);
        return EndpointPair.of(this, var2_2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> adjacentNodes(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).adjacentNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        void var2_2;
        void var3_3;
        void var1_1;
        NetworkConnections<N, E> connectionsU = this.checkedConnections(nodeU);
        if (!this.allowsSelfLoops && var1_1 == nodeV) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(nodeV), "Node %s is not an element of this graph.", nodeV);
        return var3_3.edgesConnecting(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> inEdges(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).inEdges();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> outEdges(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).outEdges();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> predecessors(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).predecessors();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<N> successors(N node) {
        void var1_1;
        return this.checkedConnections(var1_1).successors();
    }

    /*
     * WARNING - void declaration
     */
    final NetworkConnections<N, E> checkedConnections(N node) {
        void var2_2;
        NetworkConnections<N, E> connections = this.nodeConnections.get(node);
        if (connections == null) {
            void var1_1;
            Preconditions.checkNotNull(node);
            throw new IllegalArgumentException(String.format("Node %s is not an element of this graph.", var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final N checkedReferenceNode(E edge) {
        void var2_2;
        N referenceNode = this.edgeToReferenceNode.get(edge);
        if (referenceNode == null) {
            void var1_1;
            Preconditions.checkNotNull(edge);
            throw new IllegalArgumentException(String.format("Edge %s is not an element of this graph.", var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsNode(N node) {
        void var1_1;
        return this.nodeConnections.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsEdge(E edge) {
        void var1_1;
        return this.edgeToReferenceNode.containsKey(var1_1);
    }
}

