/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardValueGraph;
import com.google.common.graph.UndirectedGraphConnections;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
final class StandardMutableValueGraph<N, V>
extends StandardValueGraph<N, V>
implements MutableValueGraph<N, V> {
    private final ElementOrder<N> incidentEdgeOrder;

    /*
     * WARNING - void declaration
     */
    StandardMutableValueGraph(AbstractGraphBuilder<? super N> builder) {
        super(builder);
        void var1_1;
        this.incidentEdgeOrder = var1_1.incidentEdgeOrder.cast();
    }

    @Override
    public final ElementOrder<N> incidentEdgeOrder() {
        return this.incidentEdgeOrder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addNode(N node) {
        void var1_1;
        Preconditions.checkNotNull(node, "node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private GraphConnections<N, V> addNodeInternal(N node) {
        void var2_2;
        void var1_1;
        GraphConnections<N, V> connections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(var1_1, connections) == null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V putEdgeValue(N nodeU, N nodeV, V value) {
        void var3_3;
        void var1_1;
        GraphConnections<N, V> connectionsU;
        Preconditions.checkNotNull(nodeU, "nodeU");
        Preconditions.checkNotNull(nodeV, "nodeV");
        Preconditions.checkNotNull(value, "value");
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!nodeU.equals(nodeV), "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if ((connectionsU = this.nodeConnections.get(nodeU)) == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        Object previousValue = connectionsU.addSuccessor(nodeV, value);
        GraphConnections<void, Object> connectionsV = this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            void var2_2;
            connectionsV = this.addNodeInternal(var2_2);
        }
        connectionsV.addPredecessor(var1_1, var3_3);
        if (previousValue == null) {
            Graphs.checkPositive(++this.edgeCount);
        }
        return previousValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V putEdgeValue(EndpointPair<N> endpoints, V value) {
        void var2_2;
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.putEdgeValue(endpoints.nodeU(), var1_1.nodeV(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeNode(N node) {
        void var1_1;
        Preconditions.checkNotNull(node, "node");
        GraphConnections connections = this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        if (this.allowsSelfLoops() && connections.removeSuccessor(node) != null) {
            connections.removePredecessor(node);
            --this.edgeCount;
        }
        for (Object successor : connections.successors()) {
            Objects.requireNonNull(this.nodeConnections.getWithoutCaching(successor)).removePredecessor(node);
            --this.edgeCount;
        }
        if (this.isDirected()) {
            void var2_2;
            for (Object predecessor : var2_2.predecessors()) {
                Preconditions.checkState(Objects.requireNonNull(this.nodeConnections.getWithoutCaching(predecessor)).removeSuccessor(node) != null);
                --this.edgeCount;
            }
        }
        this.nodeConnections.remove(var1_1);
        Graphs.checkNonNegative(this.edgeCount);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V removeEdge(N nodeU, N nodeV) {
        void var2_2;
        void var3_3;
        Preconditions.checkNotNull(nodeU, "nodeU");
        Preconditions.checkNotNull(nodeV, "nodeV");
        GraphConnections connectionsU = this.nodeConnections.get(nodeU);
        GraphConnections connectionsV = this.nodeConnections.get(nodeV);
        if (connectionsU == null || connectionsV == null) {
            return null;
        }
        Object previousValue = var3_3.removeSuccessor(nodeV);
        if (previousValue != null) {
            void var1_1;
            connectionsV.removePredecessor(var1_1);
            Graphs.checkNonNegative(--this.edgeCount);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V removeEdge(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.removeEdge(endpoints.nodeU(), var1_1.nodeV());
    }

    private GraphConnections<N, V> newConnections() {
        if (this.isDirected()) {
            return DirectedGraphConnections.of(this.incidentEdgeOrder);
        }
        return UndirectedGraphConnections.of(this.incidentEdgeOrder);
    }
}

