/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.StandardNetwork;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import java.util.Iterator;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
final class StandardMutableNetwork<N, E>
extends StandardNetwork<N, E>
implements MutableNetwork<N, E> {
    /*
     * WARNING - void declaration
     */
    StandardMutableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        super(var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addNode(N node) {
        void var1_1;
        Preconditions.checkNotNull(node, "node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkConnections<N, E> addNodeInternal(N node) {
        void var2_2;
        void var1_1;
        NetworkConnections<N, E> connections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(var1_1, connections) == null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addEdge(N nodeU, N nodeV, E edge) {
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(nodeU, "nodeU");
        Preconditions.checkNotNull(nodeV, "nodeV");
        Preconditions.checkNotNull(edge, "edge");
        if (this.containsEdge(edge)) {
            EndpointPair existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair<N> newIncidentNodes = EndpointPair.of(this, nodeU, nodeV);
            Preconditions.checkArgument(existingIncidentNodes.equals(newIncidentNodes), "Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, existingIncidentNodes, newIncidentNodes);
            return false;
        }
        NetworkConnections<N, E> connectionsU = this.nodeConnections.get(nodeU);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(connectionsU == null || !connectionsU.successors().contains(nodeV), "Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!isSelfLoop, "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections<Object, E> connectionsV = this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            void var2_2;
            connectionsV = this.addNodeInternal(var2_2);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.edgeToReferenceNode.put(var3_3, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addEdge(EndpointPair<N> endpoints, E edge) {
        void var2_2;
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.addEdge(endpoints.nodeU(), var1_1.nodeV(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeNode(N node) {
        void var1_1;
        Iterator iterator;
        Preconditions.checkNotNull(node, "node");
        NetworkConnections connections = this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        for (Object edge : ImmutableList.copyOf(iterator.incidentEdges())) {
            void var3_3;
            this.removeEdge(var3_3);
        }
        this.nodeConnections.remove(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeEdge(E edge) {
        void var1_1;
        void var2_2;
        void var3_3;
        Preconditions.checkNotNull(edge, "edge");
        Object nodeU = this.edgeToReferenceNode.get(edge);
        if (nodeU == null) {
            return false;
        }
        NetworkConnections connectionsU = Objects.requireNonNull(this.nodeConnections.get(nodeU));
        Object nodeV = connectionsU.adjacentNode(edge);
        NetworkConnections connectionsV = Objects.requireNonNull(this.nodeConnections.get(nodeV));
        var3_3.removeOutEdge(edge);
        connectionsV.removeInEdge(edge, this.allowsSelfLoops() && var2_2.equals(nodeV));
        this.edgeToReferenceNode.remove(var1_1);
        return true;
    }

    private NetworkConnections<N, E> newConnections() {
        if (this.isDirected()) {
            if (this.allowsParallelEdges()) {
                return DirectedMultiNetworkConnections.of();
            }
            return DirectedNetworkConnections.of();
        }
        if (this.allowsParallelEdges()) {
            return UndirectedMultiNetworkConnections.of();
        }
        return UndirectedNetworkConnections.of();
    }
}

