/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.GraphConstants;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardMutableValueGraph;

@ElementTypesAreNonnullByDefault
final class StandardMutableGraph<N>
extends ForwardingGraph<N>
implements MutableGraph<N> {
    private final MutableValueGraph<N, GraphConstants.Presence> backingValueGraph;

    /*
     * WARNING - void declaration
     */
    StandardMutableGraph(AbstractGraphBuilder<? super N> builder) {
        void var1_1;
        this.backingValueGraph = new StandardMutableValueGraph<N, GraphConstants.Presence>(var1_1);
    }

    @Override
    final BaseGraph<N> delegate() {
        return this.backingValueGraph;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addNode(N node) {
        void var1_1;
        return this.backingValueGraph.addNode(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean putEdge(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        return this.backingValueGraph.putEdgeValue(var1_1, var2_2, GraphConstants.Presence.EDGE_EXISTS) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean putEdge(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.putEdge(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeNode(N node) {
        void var1_1;
        return this.backingValueGraph.removeNode(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeEdge(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        return this.backingValueGraph.removeEdge(var1_1, var2_2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeEdge(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.removeEdge(endpoints.nodeU(), var1_1.nodeV());
    }
}

