/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.StandardMutableNetwork;

@ElementTypesAreNonnullByDefault
@Beta
public final class NetworkBuilder<N, E>
extends AbstractGraphBuilder<N> {
    boolean allowsParallelEdges = false;
    ElementOrder<? super E> edgeOrder = ElementOrder.insertion();
    Optional<Integer> expectedEdgeCount = Optional.absent();

    /*
     * WARNING - void declaration
     */
    private NetworkBuilder(boolean directed) {
        super((boolean)var1_1);
        void var1_1;
    }

    public static NetworkBuilder<Object, Object> directed() {
        return new NetworkBuilder<Object, Object>(true);
    }

    public static NetworkBuilder<Object, Object> undirected() {
        return new NetworkBuilder<Object, Object>(false);
    }

    public static <N, E> NetworkBuilder<N, E> from(Network<N, E> network) {
        Network<N, E> network2;
        return new NetworkBuilder<N, E>(network.isDirected()).allowsParallelEdges(network.allowsParallelEdges()).allowsSelfLoops(network.allowsSelfLoops()).nodeOrder(network.nodeOrder()).edgeOrder(network2.edgeOrder());
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N, E1 extends E> ImmutableNetwork.Builder<N1, E1> immutable() {
        void var1_1;
        NetworkBuilder<N1, E1> castBuilder = this.cast();
        return new ImmutableNetwork.Builder(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final NetworkBuilder<N, E> allowsParallelEdges(boolean allowsParallelEdges) {
        void var1_1;
        this.allowsParallelEdges = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final NetworkBuilder<N, E> allowsSelfLoops(boolean allowsSelfLoops) {
        void var1_1;
        this.allowsSelfLoops = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final NetworkBuilder<N, E> expectedNodeCount(int expectedNodeCount) {
        void var1_1;
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final NetworkBuilder<N, E> expectedEdgeCount(int expectedEdgeCount) {
        void var1_1;
        this.expectedEdgeCount = Optional.of(Graphs.checkNonNegative((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> NetworkBuilder<N1, E> nodeOrder(ElementOrder<N1> nodeOrder) {
        void var2_2;
        void var1_1;
        NetworkBuilder newBuilder = this.cast();
        this.cast().nodeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <E1 extends E> NetworkBuilder<N, E1> edgeOrder(ElementOrder<E1> edgeOrder) {
        void var2_2;
        void var1_1;
        NetworkBuilder newBuilder = this.cast();
        this.cast().edgeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    public final <N1 extends N, E1 extends E> MutableNetwork<N1, E1> build() {
        return new StandardMutableNetwork(this);
    }

    private <N1 extends N, E1 extends E> NetworkBuilder<N1, E1> cast() {
        return this;
    }
}

