/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.MapIteratorCache;
import java.util.Map;

@ElementTypesAreNonnullByDefault
final class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    private volatile transient CacheEntry<K, V> cacheEntry1;
    private volatile transient CacheEntry<K, V> cacheEntry2;

    /*
     * WARNING - void declaration
     */
    MapRetrievalCache(Map<K, V> backingMap) {
        super(var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final V get(Object key) {
        void var2_2;
        Preconditions.checkNotNull(key);
        V value = this.getIfCached(key);
        if (value != null) {
            return value;
        }
        value = this.getWithoutCaching(key);
        if (value != null) {
            void var1_1;
            this.addToCache(var1_1, value);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final V getIfCached(Object key) {
        void var1_1;
        Object value = super.getIfCached(key);
        if (value != null) {
            return value;
        }
        CacheEntry<K, V> entry = this.cacheEntry1;
        if (entry != null && entry.key == key) {
            return entry.value;
        }
        entry = this.cacheEntry2;
        if (entry != null && entry.key == var1_1) {
            void var2_2;
            this.addToCache(entry);
            return var2_2.value;
        }
        return null;
    }

    @Override
    final void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    /*
     * WARNING - void declaration
     */
    private void addToCache(K key, V value) {
        void var2_2;
        void var1_1;
        this.addToCache(new CacheEntry<void, void>(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void addToCache(CacheEntry<K, V> entry) {
        void var1_1;
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = var1_1;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        /*
         * WARNING - void declaration
         */
        CacheEntry(K key, V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }
    }
}

