/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    private volatile transient Map.Entry<K, V> cacheEntry;

    /*
     * WARNING - void declaration
     */
    MapIteratorCache(Map<K, V> backingMap) {
        void var1_1;
        this.backingMap = (Map)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final V put(K key, V value) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.clearCache();
        return this.backingMap.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final V remove(Object key) {
        void var1_1;
        Preconditions.checkNotNull(key);
        this.clearCache();
        return this.backingMap.remove(var1_1);
    }

    final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    V get(Object key) {
        void var2_2;
        Preconditions.checkNotNull(key);
        V value = this.getIfCached(key);
        if (value == null) {
            void var1_1;
            return this.getWithoutCaching(var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final V getWithoutCaching(Object key) {
        void var1_1;
        Preconditions.checkNotNull(key);
        return this.backingMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsKey(Object key) {
        void var1_1;
        return this.getIfCached(key) != null || this.backingMap.containsKey(var1_1);
    }

    final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(this){
            final /* synthetic */ MapIteratorCache this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public UnmodifiableIterator<K> iterator() {
                void var1_1;
                Iterator entryIterator = this.this$0.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(this, (Iterator)var1_1){
                    final /* synthetic */ Iterator val$entryIterator;
                    final /* synthetic */ 1 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$entryIterator = iterator;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$entryIterator.hasNext();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public K next() {
                        void var1_1;
                        Map.Entry entry = (Map.Entry)this.val$entryIterator.next();
                        MapIteratorCache.access$102(this.this$1.this$0, entry);
                        return var1_1.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.backingMap.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object key) {
                void var1_1;
                return this.this$0.containsKey(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    V getIfCached(Object key) {
        void var1_1;
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == var1_1) {
            void var2_2;
            return var2_2.getValue();
        }
        return null;
    }

    void clearCache() {
        this.cacheEntry = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map.Entry access$102(MapIteratorCache x0, Map.Entry x1) {
        void var1_1;
        x0.cacheEntry = var1_1;
        return x0.cacheEntry;
    }
}

