/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import java.util.AbstractSet;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class IncidentEdgeSet<N>
extends AbstractSet<EndpointPair<N>> {
    final N node;
    final BaseGraph<N> graph;

    /*
     * WARNING - void declaration
     */
    IncidentEdgeSet(BaseGraph<N> graph, N node) {
        void var2_2;
        void var1_1;
        this.graph = var1_1;
        this.node = var2_2;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.graph.isDirected()) {
            return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - (this.graph.successors((Object)this.node).contains(this.node) ? 1 : 0);
        }
        return this.graph.adjacentNodes(this.node).size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object obj) {
        void var1_1;
        void var2_3;
        void var3_5;
        if (!(obj instanceof EndpointPair)) {
            return false;
        }
        EndpointPair endpointPair = (EndpointPair)obj;
        if (this.graph.isDirected()) {
            if (!endpointPair.isOrdered()) {
                return false;
            }
            Object source = endpointPair.source();
            Object target = endpointPair.target();
            return this.node.equals(source) && this.graph.successors((Object)this.node).contains(target) || this.node.equals(target) && this.graph.predecessors((Object)this.node).contains(source);
        }
        if (endpointPair.isOrdered()) {
            return false;
        }
        Set<N> adjacent = this.graph.adjacentNodes(this.node);
        Object nodeU = endpointPair.nodeU();
        Object nodeV = endpointPair.nodeV();
        return this.node.equals(nodeV) && adjacent.contains(nodeU) || this.node.equals(var3_5) && var2_3.contains(var1_1);
    }
}

