/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardValueGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@Beta
public final class ImmutableValueGraph<N, V>
extends StandardValueGraph<N, V> {
    /*
     * WARNING - void declaration
     */
    private ImmutableValueGraph(ValueGraph<N, V> graph) {
        super(ValueGraphBuilder.from(graph), ImmutableValueGraph.getNodeConnections(graph), var1_1.edges().size());
        void var1_1;
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph) {
        ValueGraph<N, V> valueGraph;
        if (graph instanceof ImmutableValueGraph) {
            return (ImmutableValueGraph)graph;
        }
        return new ImmutableValueGraph<N, V>(valueGraph);
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public final ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    @Override
    public final ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }

    /*
     * WARNING - void declaration
     */
    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> graph) {
        void var1_1;
        ImmutableMap.Builder<N, GraphConnections<void, V>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            void var3_3;
            nodeConnections.put(node, ImmutableValueGraph.connectionsOf(graph, var3_3));
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    private static <N, V> GraphConnections<N, V> connectionsOf(ValueGraph<N, V> graph, N node) {
        void var2_2;
        void var1_1;
        ValueGraph<void, V> valueGraph;
        Function successorNodeToValueFn = successorNode -> {
            void var2_2;
            void var1_1;
            return Objects.requireNonNull(graph.edgeValueOrDefault(var1_1, var2_2, null));
        };
        if (graph.isDirected()) {
            return DirectedGraphConnections.ofImmutable(node, graph.incidentEdges(node), successorNodeToValueFn);
        }
        return UndirectedGraphConnections.ofImmutable(Maps.asMap(valueGraph.adjacentNodes(var1_1), var2_2));
    }

    public static class Builder<N, V> {
        private final MutableValueGraph<N, V> mutableValueGraph;

        /*
         * WARNING - void declaration
         */
        Builder(ValueGraphBuilder<N, V> graphBuilder) {
            void var1_1;
            this.mutableValueGraph = var1_1.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, V> addNode(N node) {
            void var1_1;
            this.mutableValueGraph.addNode(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, V> putEdgeValue(N nodeU, N nodeV, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mutableValueGraph.putEdgeValue(var1_1, var2_2, var3_3);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, V> putEdgeValue(EndpointPair<N> endpoints, V value) {
            void var2_2;
            void var1_1;
            this.mutableValueGraph.putEdgeValue((EndpointPair<N>)var1_1, var2_2);
            return this;
        }

        public ImmutableValueGraph<N, V> build() {
            return ImmutableValueGraph.copyOf(this.mutableValueGraph);
        }
    }
}

