/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.StandardNetwork;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@Beta
public final class ImmutableNetwork<N, E>
extends StandardNetwork<N, E> {
    /*
     * WARNING - void declaration
     */
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(var1_1));
        void var1_1;
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        Network<N, E> network2;
        if (network instanceof ImmutableNetwork) {
            return (ImmutableNetwork)network;
        }
        return new ImmutableNetwork<N, E>(network2);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> network) {
        return Preconditions.checkNotNull(network);
    }

    @Override
    public final ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(super.asGraph());
    }

    /*
     * WARNING - void declaration
     */
    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        void var1_1;
        ImmutableMap.Builder<N, NetworkConnections<void, E>> nodeConnections = ImmutableMap.builder();
        for (N node : network.nodes()) {
            void var3_3;
            nodeConnections.put(node, ImmutableNetwork.connectionsOf(network, var3_3));
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        void var1_1;
        ImmutableMap.Builder<E, N> edgeToReferenceNode = ImmutableMap.builder();
        for (E edge : network.edges()) {
            void var3_3;
            edgeToReferenceNode.put(edge, network.incidentNodes(var3_3).nodeU());
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N node) {
        void var2_4;
        Network<N, E> network2;
        void var1_1;
        if (network.isDirected()) {
            void var1_2;
            void var3_5;
            Map<E, N> inEdgeMap = Maps.asMap(network.inEdges((void)node), ImmutableNetwork.sourceNodeFn(network));
            Map<E, N> outEdgeMap = Maps.asMap(network.outEdges((void)node), ImmutableNetwork.targetNodeFn(network));
            N n = node;
            int selfLoopCount = network.edgesConnecting((void)n, (void)n).size();
            if (network.allowsParallelEdges()) {
                return DirectedMultiNetworkConnections.ofImmutable(inEdgeMap, outEdgeMap, selfLoopCount);
            }
            return DirectedNetworkConnections.ofImmutable(inEdgeMap, var3_5, (int)var1_2);
        }
        Map<E, void> incidentEdgeMap = Maps.asMap(network.incidentEdges(var1_1), ImmutableNetwork.adjacentNodeFn(network, var1_1));
        if (network2.allowsParallelEdges()) {
            return UndirectedMultiNetworkConnections.ofImmutable(incidentEdgeMap);
        }
        return UndirectedNetworkConnections.ofImmutable(var2_4);
    }

    private static <N, E> Function<E, N> sourceNodeFn(Network<N, E> network) {
        return edge -> {
            void var1_1;
            return network.incidentNodes(var1_1).source();
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(Network<N, E> network) {
        return edge -> {
            void var1_1;
            return network.incidentNodes(var1_1).target();
        };
    }

    /*
     * WARNING - void declaration
     */
    private static <N, E> Function<E, N> adjacentNodeFn(Network<N, E> network, N node) {
        void var1_1;
        return edge -> {
            void var1_1;
            void var2_2;
            return network.incidentNodes(var2_2).adjacentNode(var1_1);
        };
    }

    public static class Builder<N, E> {
        private final MutableNetwork<N, E> mutableNetwork;

        /*
         * WARNING - void declaration
         */
        Builder(NetworkBuilder<N, E> networkBuilder) {
            void var1_1;
            this.mutableNetwork = var1_1.build();
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, E> addNode(N node) {
            void var1_1;
            this.mutableNetwork.addNode(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, E> addEdge(N nodeU, N nodeV, E edge) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mutableNetwork.addEdge(var1_1, var2_2, var3_3);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N, E> addEdge(EndpointPair<N> endpoints, E edge) {
            void var2_2;
            void var1_1;
            this.mutableNetwork.addEdge((EndpointPair<N>)var1_1, var2_2);
            return this;
        }

        public ImmutableNetwork<N, E> build() {
            return ImmutableNetwork.copyOf(this.mutableNetwork);
        }
    }
}

