/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.GraphConstants;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.StandardValueGraph;
import com.google.common.graph.UndirectedGraphConnections;

@ElementTypesAreNonnullByDefault
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    /*
     * WARNING - void declaration
     */
    ImmutableGraph(BaseGraph<N> backingGraph) {
        void var1_1;
        this.backingGraph = var1_1;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        Graph<N> graph2;
        if (graph instanceof ImmutableGraph) {
            return (ImmutableGraph)graph;
        }
        return new ImmutableGraph<N>(new StandardValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph2.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    /*
     * WARNING - void declaration
     */
    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        void var1_1;
        ImmutableMap.Builder<N, GraphConnections<void, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            void var3_3;
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, var3_3));
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        void var2_2;
        void var1_1;
        Graph<void> graph2;
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        if (graph.isDirected()) {
            return DirectedGraphConnections.ofImmutable(node, graph.incidentEdges(node), edgeValueFn);
        }
        return UndirectedGraphConnections.ofImmutable(Maps.asMap(graph2.adjacentNodes(var1_1), var2_2));
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        /*
         * WARNING - void declaration
         */
        Builder(GraphBuilder<N> graphBuilder) {
            void var1_1;
            this.mutableGraph = var1_1.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N> addNode(N node) {
            void var1_1;
            this.mutableGraph.addNode(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N> putEdge(N nodeU, N nodeV) {
            void var2_2;
            void var1_1;
            this.mutableGraph.putEdge(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            void var1_1;
            this.mutableGraph.putEdge((EndpointPair<N>)var1_1);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

