/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.ForwardingNetwork;
import com.google.common.graph.ForwardingValueGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.Traverser;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@Beta
public final class Graphs {
    private Graphs() {
    }

    /*
     * WARNING - void declaration
     */
    public static <N> boolean hasCycle(Graph<N> graph) {
        int numEdges = graph.edges().size();
        if (numEdges == 0) {
            return false;
        }
        if (!graph.isDirected() && numEdges >= graph.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> visitedNodes = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        for (N node : graph.nodes()) {
            void var3_4;
            if (!Graphs.subgraphHasCycle(graph, visitedNodes, var3_4, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        Network<?, ?> network2;
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network2.asGraph());
    }

    /*
     * WARNING - void declaration
     */
    private static <N> boolean subgraphHasCycle(Graph<N> graph, Map<Object, NodeVisitState> visitedNodes, N node, N previousNode) {
        void var2_2;
        void var1_1;
        NodeVisitState state = visitedNodes.get(node);
        if (state == NodeVisitState.COMPLETE) {
            return false;
        }
        if (state == NodeVisitState.PENDING) {
            return true;
        }
        visitedNodes.put(node, NodeVisitState.PENDING);
        for (Object nextNode : graph.successors((Object)node)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph, nextNode, previousNode) || !Graphs.subgraphHasCycle(graph, visitedNodes, nextNode, node)) continue;
            return true;
        }
        var1_1.put(var2_2, NodeVisitState.COMPLETE);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, Object nextNode, Object previousNode) {
        void var1_1;
        void var2_2;
        return graph.isDirected() || !com.google.common.base.Objects.equal(var2_2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <N> Graph<N> transitiveClosure(Graph<N> graph) {
        void var1_1;
        MutableGraph transitiveClosure = GraphBuilder.from(graph).allowsSelfLoops(true).build();
        if (graph.isDirected()) {
            for (N node : graph.nodes()) {
                for (N reachableNode : Graphs.reachableNodes(graph, node)) {
                    transitiveClosure.putEdge(node, reachableNode);
                }
            }
        } else {
            HashSet<N> visitedNodes = new HashSet<N>();
            for (N node : graph.nodes()) {
                if (visitedNodes.contains(node)) continue;
                Set<N> reachableNodes = Graphs.reachableNodes(graph, node);
                visitedNodes.addAll(reachableNodes);
                int pairwiseMatch = 1;
                for (N nodeU : reachableNodes) {
                    for (N nodeV : Iterables.limit(reachableNodes, pairwiseMatch++)) {
                        transitiveClosure.putEdge(nodeU, nodeV);
                    }
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <N> Set<N> reachableNodes(Graph<N> graph, N node) {
        void var1_1;
        Graph<N> graph2;
        Preconditions.checkArgument(graph.nodes().contains(node), "Node %s is not an element of this graph.", node);
        return ImmutableSet.copyOf(Traverser.forGraph(graph2).breadthFirst(var1_1));
    }

    public static <N> Graph<N> transpose(Graph<N> graph) {
        Graph<N> graph2;
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph2);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> graph) {
        ValueGraph<N, V> valueGraph;
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)graph).graph;
        }
        return new TransposedValueGraph<N, V>(valueGraph);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        Network<N, E> network2;
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network2);
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpoints) {
        EndpointPair<N> endpointPair;
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered(endpoints.target(), endpoints.source());
        }
        return endpointPair;
    }

    /*
     * WARNING - void declaration
     */
    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> nodes) {
        void var2_2;
        Iterator<Object> iterator;
        MutableGraph subgraph = nodes instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : GraphBuilder.from(graph).build();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object node = iterator.next();
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdge(node, successorNode);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> graph, Iterable<? extends N> nodes) {
        void var2_2;
        Iterator<Object> iterator;
        MutableValueGraph subgraph = nodes instanceof Collection ? ValueGraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : ValueGraphBuilder.from(graph).build();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object node = iterator.next();
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdgeValue(node, successorNode, Objects.requireNonNull(graph.edgeValueOrDefault(node, successorNode, null)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> nodes) {
        void var2_2;
        Iterator<Object> iterator;
        MutableNetwork subgraph = nodes instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)nodes).size()).build() : NetworkBuilder.from(network).build();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object node = iterator.next();
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (E edge : network.outEdges(node)) {
                N successorNode = network.incidentNodes(edge).adjacentNode(node);
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.addEdge(node, successorNode, edge);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <N> MutableGraph<N> copyOf(Graph<N> graph) {
        void var1_1;
        Graph<N> graph2;
        MutableGraph copy = GraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (N n : graph.nodes()) {
            copy.addNode(n);
        }
        for (EndpointPair endpointPair : graph2.edges()) {
            copy.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph) {
        void var1_1;
        MutableValueGraph copy = ValueGraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (Object n : graph.nodes()) {
            copy.addNode(n);
        }
        for (EndpointPair endpointPair : graph.edges()) {
            copy.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), Objects.requireNonNull(graph.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null)));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        void var1_1;
        MutableNetwork copy = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (N node : network.nodes()) {
            copy.addNode(node);
        }
        for (Object edge : network.edges()) {
            void var3_3;
            EndpointPair<N> endpointPair = network.incidentNodes(edge);
            copy.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), var3_3);
        }
        return var1_1;
    }

    static int checkNonNegative(int value) {
        int n;
        Preconditions.checkArgument(value >= 0, "Not true that %s is non-negative.", value);
        return n;
    }

    static long checkNonNegative(long value) {
        long l;
        Preconditions.checkArgument(value >= 0L, "Not true that %s is non-negative.", value);
        return l;
    }

    static int checkPositive(int value) {
        int n;
        Preconditions.checkArgument(value > 0, "Not true that %s is positive.", value);
        return n;
    }

    static long checkPositive(long value) {
        long l;
        Preconditions.checkArgument(value > 0L, "Not true that %s is positive.", value);
        return l;
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        /*
         * WARNING - void declaration
         */
        TransposedNetwork(Network<N, E> network) {
            void var1_1;
            this.network = var1_1;
        }

        @Override
        Network<N, E> delegate() {
            return this.network;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> predecessors(N node) {
            void var1_1;
            return this.delegate().successors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> successors(N node) {
            void var1_1;
            return this.delegate().predecessors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int inDegree(N node) {
            void var1_1;
            return this.delegate().outDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int outDegree(N node) {
            void var1_1;
            return this.delegate().inDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<E> inEdges(N node) {
            void var1_1;
            return this.delegate().outEdges(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<E> outEdges(N node) {
            void var1_1;
            return this.delegate().inEdges(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EndpointPair<N> incidentNodes(E edge) {
            void var1_1;
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(edge);
            return EndpointPair.of(this.network, endpointPair.nodeV(), var1_1.nodeU());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<E> edgesConnecting(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().edgesConnecting(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().edgesConnecting(Graphs.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Optional<E> edgeConnecting(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().edgeConnecting(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().edgeConnecting(Graphs.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E edgeConnectingOrNull(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().edgeConnectingOrNull(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().hasEdgeConnecting(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().hasEdgeConnecting(Graphs.transpose(var1_1));
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        /*
         * WARNING - void declaration
         */
        TransposedValueGraph(ValueGraph<N, V> graph) {
            void var1_1;
            this.graph = var1_1;
        }

        @Override
        ValueGraph<N, V> delegate() {
            return this.graph;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> predecessors(N node) {
            void var1_1;
            return this.delegate().successors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> successors(N node) {
            void var1_1;
            return this.delegate().predecessors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int inDegree(N node) {
            void var1_1;
            return this.delegate().outDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int outDegree(N node) {
            void var1_1;
            return this.delegate().inDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().hasEdgeConnecting(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().hasEdgeConnecting(Graphs.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Optional<V> edgeValue(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().edgeValue(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().edgeValue(Graphs.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V edgeValueOrDefault(N nodeU, N nodeV, V defaultValue) {
            void var3_3;
            void var1_1;
            void var2_2;
            return this.delegate().edgeValueOrDefault(var2_2, var1_1, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V edgeValueOrDefault(EndpointPair<N> endpoints, V defaultValue) {
            void var2_2;
            void var1_1;
            return this.delegate().edgeValueOrDefault(Graphs.transpose(var1_1), var2_2);
        }
    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        /*
         * WARNING - void declaration
         */
        TransposedGraph(Graph<N> graph) {
            void var1_1;
            this.graph = var1_1;
        }

        @Override
        Graph<N> delegate() {
            return this.graph;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> predecessors(N node) {
            void var1_1;
            return this.delegate().successors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<N> successors(N node) {
            void var1_1;
            return this.delegate().predecessors((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<EndpointPair<N>> incidentEdges(N node) {
            void var1_1;
            TransposedGraph transposedGraph = this;
            return new IncidentEdgeSet<N>(transposedGraph, transposedGraph, var1_1){
                final /* synthetic */ TransposedGraph this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2, var3_3);
                }

                @Override
                public Iterator<EndpointPair<N>> iterator() {
                    return Iterators.transform(this.this$0.delegate().incidentEdges(this.node).iterator(), new Function<EndpointPair<N>, EndpointPair<N>>(this){
                        final /* synthetic */ 1 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public EndpointPair<N> apply(EndpointPair<N> edge) {
                            void var1_1;
                            return EndpointPair.of(this.this$1.this$0.delegate(), edge.nodeV(), var1_1.nodeU());
                        }
                    });
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int inDegree(N node) {
            void var1_1;
            return this.delegate().outDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int outDegree(N node) {
            void var1_1;
            return this.delegate().inDegree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            void var1_1;
            void var2_2;
            return this.delegate().hasEdgeConnecting(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            void var1_1;
            return this.delegate().hasEdgeConnecting(Graphs.transpose(var1_1));
        }
    }
}

