/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.StandardMutableGraph;

@ElementTypesAreNonnullByDefault
@Beta
public final class GraphBuilder<N>
extends AbstractGraphBuilder<N> {
    /*
     * WARNING - void declaration
     */
    private GraphBuilder(boolean directed) {
        super((boolean)var1_1);
        void var1_1;
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        Graph<N> graph2;
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder()).incidentEdgeOrder(graph2.incidentEdgeOrder());
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> ImmutableGraph.Builder<N1> immutable() {
        void var1_1;
        GraphBuilder<N1> castBuilder = this.cast();
        return new ImmutableGraph.Builder(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        void var1_1;
        this.allowsSelfLoops = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        void var1_1;
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> GraphBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        void var2_2;
        void var1_1;
        GraphBuilder<N1> newBuilder = this.cast();
        this.cast().nodeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <N1 extends N> GraphBuilder<N1> incidentEdgeOrder(ElementOrder<N1> incidentEdgeOrder) {
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(incidentEdgeOrder.type() == ElementOrder.Type.UNORDERED || incidentEdgeOrder.type() == ElementOrder.Type.STABLE, "The given elementOrder (%s) is unsupported. incidentEdgeOrder() only supports ElementOrder.unordered() and ElementOrder.stable().", incidentEdgeOrder);
        GraphBuilder<N1> newBuilder = this.cast();
        this.cast().incidentEdgeOrder = (ElementOrder)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    public final <N1 extends N> MutableGraph<N1> build() {
        return new StandardMutableGraph(this);
    }

    /*
     * WARNING - void declaration
     */
    final GraphBuilder<N> copy() {
        void var1_1;
        GraphBuilder<N> newBuilder = new GraphBuilder<N>(this.directed);
        new GraphBuilder<N>(this.directed).allowsSelfLoops = this.allowsSelfLoops;
        newBuilder.nodeOrder = this.nodeOrder;
        newBuilder.expectedNodeCount = this.expectedNodeCount;
        newBuilder.incidentEdgeOrder = this.incidentEdgeOrder;
        return var1_1;
    }

    private <N1 extends N> GraphBuilder<N1> cast() {
        return this;
    }
}

