/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class EndpointPair<N>
implements Iterable<N> {
    private final N nodeU;
    private final N nodeV;

    /*
     * WARNING - void declaration
     */
    private EndpointPair(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        this.nodeU = Preconditions.checkNotNull(var1_1);
        this.nodeV = Preconditions.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <N> EndpointPair<N> ordered(N source, N target) {
        void var1_1;
        N n;
        return new Ordered(n, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <N> EndpointPair<N> unordered(N nodeU, N nodeV) {
        N n;
        void var1_1;
        return new Unordered(var1_1, n);
    }

    /*
     * WARNING - void declaration
     */
    static <N> EndpointPair<N> of(Graph<?> graph, N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        if (graph.isDirected()) {
            return EndpointPair.ordered(nodeU, nodeV);
        }
        return EndpointPair.unordered(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static <N> EndpointPair<N> of(Network<?, ?> network, N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        if (network.isDirected()) {
            return EndpointPair.ordered(nodeU, nodeV);
        }
        return EndpointPair.unordered(var1_1, var2_2);
    }

    public abstract N source();

    public abstract N target();

    public final N nodeU() {
        return this.nodeU;
    }

    public final N nodeV() {
        return this.nodeV;
    }

    public final N adjacentNode(N node) {
        String string;
        if (node.equals(this.nodeU)) {
            return this.nodeV;
        }
        if (node.equals(this.nodeV)) {
            return this.nodeU;
        }
        String string2 = String.valueOf(this);
        string = String.valueOf(string);
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string2).length() + String.valueOf(string).length()).append("EndpointPair ").append(string2).append(" does not contain node ").append(string).toString());
    }

    public abstract boolean isOrdered();

    @Override
    public final UnmodifiableIterator<N> iterator() {
        return Iterators.forArray(this.nodeU, this.nodeV);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static final class Unordered<N>
    extends EndpointPair<N> {
        /*
         * WARNING - void declaration
         */
        private Unordered(N nodeU, N nodeV) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final N source() {
            throw new UnsupportedOperationException("Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public final N target() {
            throw new UnsupportedOperationException("Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public final boolean isOrdered() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object obj) {
            void var1_1;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (((EndpointPair)this).isOrdered() != other.isOrdered()) {
                return false;
            }
            if (this.nodeU().equals(other.nodeU())) {
                return this.nodeV().equals(other.nodeV());
            }
            return this.nodeU().equals(other.nodeV()) && this.nodeV().equals(var1_1.nodeU());
        }

        @Override
        public final int hashCode() {
            return this.nodeU().hashCode() + this.nodeV().hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.nodeU());
            String string2 = String.valueOf(this.nodeV());
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[").append(string).append(", ").append(string2).append("]").toString();
        }
    }

    private static final class Ordered<N>
    extends EndpointPair<N> {
        /*
         * WARNING - void declaration
         */
        private Ordered(N source, N target) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final N source() {
            return this.nodeU();
        }

        @Override
        public final N target() {
            return this.nodeV();
        }

        @Override
        public final boolean isOrdered() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object obj) {
            void var1_1;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (((EndpointPair)this).isOrdered() != other.isOrdered()) {
                return false;
            }
            return ((EndpointPair)this).source().equals(other.source()) && ((EndpointPair)this).target().equals(var1_1.target());
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(((EndpointPair)this).source(), ((EndpointPair)this).target());
        }

        public final String toString() {
            String string = String.valueOf(((EndpointPair)this).source());
            String string2 = String.valueOf(((EndpointPair)this).target());
            return new StringBuilder(6 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append(" -> ").append(string2).append(">").toString();
        }
    }
}

