/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.Comparator;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@Beta
public final class ElementOrder<T> {
    private final Type type;
    private final Comparator<T> comparator;

    /*
     * WARNING - void declaration
     */
    private ElementOrder(Type type, Comparator<T> comparator) {
        void var2_2;
        void var1_1;
        this.type = Preconditions.checkNotNull(type);
        this.comparator = comparator;
        Preconditions.checkState(var1_1 == Type.SORTED == (var2_2 != null));
    }

    public static <S> ElementOrder<S> unordered() {
        return new ElementOrder(Type.UNORDERED, null);
    }

    public static <S> ElementOrder<S> stable() {
        return new ElementOrder(Type.STABLE, null);
    }

    public static <S> ElementOrder<S> insertion() {
        return new ElementOrder(Type.INSERTION, null);
    }

    public static <S extends Comparable<? super S>> ElementOrder<S> natural() {
        return new ElementOrder(Type.SORTED, Ordering.natural());
    }

    public static <S> ElementOrder<S> sorted(Comparator<S> comparator) {
        Comparator<S> comparator2;
        return new ElementOrder<S>(Type.SORTED, Preconditions.checkNotNull(comparator2));
    }

    public final Type type() {
        return this.type;
    }

    public final Comparator<T> comparator() {
        if (this.comparator != null) {
            return this.comparator;
        }
        throw new UnsupportedOperationException("This ordering does not define a comparator.");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementOrder)) {
            return false;
        }
        ElementOrder other = (ElementOrder)obj;
        return this.type == other.type && Objects.equal(this.comparator, var1_1.comparator);
    }

    public final int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.comparator});
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("type", (Object)this.type);
        if (this.comparator != null) {
            helper.add("comparator", this.comparator);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    final <K extends T, V> Map<K, V> createMap(int expectedSize) {
        switch (this.type) {
            case UNORDERED: {
                return Maps.newHashMapWithExpectedSize(expectedSize);
            }
            case INSERTION: 
            case STABLE: {
                void var1_1;
                return Maps.newLinkedHashMapWithExpectedSize((int)var1_1);
            }
            case SORTED: {
                return Maps.newTreeMap(this.comparator());
            }
        }
        throw new AssertionError();
    }

    final <T1 extends T> ElementOrder<T1> cast() {
        return this;
    }

    public static enum Type {
        UNORDERED,
        STABLE,
        INSERTION,
        SORTED;

    }
}

