/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.AbstractSet;
import java.util.Map;

@ElementTypesAreNonnullByDefault
final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    /*
     * WARNING - void declaration
     */
    EdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        void var2_2;
        void var1_1;
        this.nodeToOutEdge = (Map)Preconditions.checkNotNull(var1_1);
        this.targetNode = Preconditions.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final UnmodifiableIterator<E> iterator() {
        void var1_1;
        E connectingEdge = this.getConnectingEdge();
        if (connectingEdge == null) {
            return ((ImmutableCollection)ImmutableSet.of()).iterator();
        }
        return Iterators.singletonIterator(var1_1);
    }

    @Override
    public final int size() {
        if (this.getConnectingEdge() == null) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object edge) {
        void var1_1;
        void var2_2;
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && var2_2.equals(var1_1);
    }

    private E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

