/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.graph.AbstractDirectedNetworkConnections;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.MultiEdgesConnecting;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class DirectedMultiNetworkConnections<N, E>
extends AbstractDirectedNetworkConnections<N, E> {
    private transient Reference<Multiset<N>> predecessorsReference;
    private transient Reference<Multiset<N>> successorsReference;

    /*
     * WARNING - void declaration
     */
    private DirectedMultiNetworkConnections(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        super(var1_1, var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static <N, E> DirectedMultiNetworkConnections<N, E> of() {
        return new DirectedMultiNetworkConnections(new HashMap(2, 1.0f), new HashMap(2, 1.0f), 0);
    }

    /*
     * WARNING - void declaration
     */
    static <N, E> DirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        void var2_2;
        void var1_1;
        Map<E, N> map;
        return new DirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(map), ImmutableMap.copyOf(var1_1), (int)var2_2);
    }

    @Override
    public final Set<N> predecessors() {
        return Collections.unmodifiableSet(this.predecessorsMultiset().elementSet());
    }

    /*
     * WARNING - void declaration
     */
    private Multiset<N> predecessorsMultiset() {
        void var1_1;
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors == null) {
            predecessors = HashMultiset.create(this.inEdgeMap.values());
            this.predecessorsReference = new SoftReference<Multiset<N>>(predecessors);
        }
        return var1_1;
    }

    @Override
    public final Set<N> successors() {
        return Collections.unmodifiableSet(this.successorsMultiset().elementSet());
    }

    /*
     * WARNING - void declaration
     */
    private Multiset<N> successorsMultiset() {
        void var1_1;
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors == null) {
            successors = HashMultiset.create(this.outEdgeMap.values());
            this.successorsReference = new SoftReference<Multiset<N>>(successors);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<E> edgesConnecting(N node) {
        void var1_1;
        DirectedMultiNetworkConnections directedMultiNetworkConnections = this;
        void v1 = var1_1;
        return new MultiEdgesConnecting<E>(directedMultiNetworkConnections, directedMultiNetworkConnections.outEdgeMap, v1, v1){
            final /* synthetic */ Object val$node;
            final /* synthetic */ DirectedMultiNetworkConnections this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$node = object;
                super(var2_2, var3_3);
            }

            @Override
            public int size() {
                return this.this$0.successorsMultiset().count(this.val$node);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final N removeInEdge(E edge, boolean isSelfLoop) {
        void var1_1;
        Object node = super.removeInEdge(edge, isSelfLoop);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            void var2_3;
            Preconditions.checkState(var2_3.remove(node));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final N removeOutEdge(E edge) {
        void var1_1;
        Object node = super.removeOutEdge(edge);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            void var2_2;
            Preconditions.checkState(var2_2.remove(node));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addInEdge(E edge, N node, boolean isSelfLoop) {
        void var3_3;
        super.addInEdge(edge, node, (boolean)var3_3);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            void var2_2;
            void var1_1;
            Preconditions.checkState(var1_1.add(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addOutEdge(E edge, N node) {
        super.addOutEdge(edge, node);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            void var2_2;
            void var1_1;
            Preconditions.checkState(var1_1.add(var2_2));
        }
    }

    private static <T> T getReference(Reference<T> reference) {
        Reference<T> reference2;
        if (reference == null) {
            return null;
        }
        return reference2.get();
    }
}

