/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@ElementTypesAreNonnullByDefault
final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    private final List<NodeConnection<N>> orderedNodeConnections;
    private int predecessorCount;
    private int successorCount;

    /*
     * WARNING - void declaration
     */
    private DirectedGraphConnections(Map<N, Object> adjacentNodeValues, List<NodeConnection<N>> orderedNodeConnections, int predecessorCount, int successorCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.adjacentNodeValues = Preconditions.checkNotNull(adjacentNodeValues);
        this.orderedNodeConnections = var2_2;
        this.predecessorCount = Graphs.checkNonNegative(predecessorCount);
        this.successorCount = Graphs.checkNonNegative(successorCount);
        Preconditions.checkState(var3_3 <= adjacentNodeValues.size() && successorCount <= var1_1.size());
    }

    static <N, V> DirectedGraphConnections<N, V> of(ElementOrder<N> incidentEdgeOrder) {
        Object object;
        switch (incidentEdgeOrder.type()) {
            case UNORDERED: {
                Object orderedNodeConnections = null;
                break;
            }
            case STABLE: {
                Object orderedNodeConnections = new ArrayList();
                break;
            }
            default: {
                Object orderedNodeConnections;
                throw new AssertionError((Object)((ElementOrder)orderedNodeConnections).type());
            }
        }
        return new DirectedGraphConnections(new HashMap(4, 1.0f), object, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    static <N, V> DirectedGraphConnections<N, V> ofImmutable(N thisNode, Iterable<EndpointPair<N>> incidentEdges, Function<N, V> successorNodeToValueFn) {
        void var3_3;
        Iterator iterator;
        Preconditions.checkNotNull(thisNode);
        Preconditions.checkNotNull(successorNodeToValueFn);
        HashMap adjacentNodeValues = new HashMap();
        ImmutableList.Builder orderedNodeConnectionsBuilder = ImmutableList.builder();
        int predecessorCount = 0;
        int successorCount = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object predecessor;
            EndpointPair incidentEdge = (EndpointPair)iterator.next();
            if (incidentEdge.nodeU().equals(thisNode) && incidentEdge.nodeV().equals(thisNode)) {
                adjacentNodeValues.put(thisNode, new PredAndSucc(successorNodeToValueFn.apply(thisNode)));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred<N>(thisNode));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Succ<N>(thisNode));
                ++predecessorCount;
                ++successorCount;
                continue;
            }
            if (incidentEdge.nodeV().equals(thisNode)) {
                predecessor = incidentEdge.nodeU();
                Object existingValue = adjacentNodeValues.put(predecessor, PRED);
                if (existingValue != null) {
                    adjacentNodeValues.put(predecessor, new PredAndSucc(existingValue));
                }
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred(predecessor));
                ++predecessorCount;
                continue;
            }
            Preconditions.checkArgument(((EndpointPair)predecessor).nodeU().equals(thisNode));
            Object successor = ((EndpointPair)predecessor).nodeV();
            V value = successorNodeToValueFn.apply((N)successor);
            V existingValue = adjacentNodeValues.put(successor, value);
            if (existingValue != null) {
                Preconditions.checkArgument(existingValue == PRED);
                adjacentNodeValues.put(successor, new PredAndSucc(value));
            }
            orderedNodeConnectionsBuilder.add(new NodeConnection.Succ(successor));
            ++successorCount;
        }
        return new DirectedGraphConnections<N, V>(var3_3, orderedNodeConnectionsBuilder.build(), predecessorCount, successorCount);
    }

    @Override
    public final Set<N> adjacentNodes() {
        if (this.orderedNodeConnections == null) {
            return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
        }
        return new AbstractSet<N>(this){
            final /* synthetic */ DirectedGraphConnections this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public UnmodifiableIterator<N> iterator() {
                void var2_2;
                void var1_1;
                Iterator nodeConnections = this.this$0.orderedNodeConnections.iterator();
                HashSet seenNodes = new HashSet();
                return new AbstractIterator<N>(this, (Iterator)var1_1, (Set)var2_2){
                    final /* synthetic */ Iterator val$nodeConnections;
                    final /* synthetic */ Set val$seenNodes;
                    {
                        this.val$nodeConnections = iterator;
                        this.val$seenNodes = set;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected N computeNext() {
                        while (this.val$nodeConnections.hasNext()) {
                            void var1_1;
                            NodeConnection nodeConnection = (NodeConnection)this.val$nodeConnections.next();
                            boolean bl = this.val$seenNodes.add(nodeConnection.node);
                            if (!bl) continue;
                            return var1_1.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.adjacentNodeValues.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                return this.this$0.adjacentNodeValues.containsKey(var1_1);
            }
        };
    }

    @Override
    public final Set<N> predecessors() {
        return new AbstractSet<N>(this){
            final /* synthetic */ DirectedGraphConnections this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public UnmodifiableIterator<N> iterator() {
                void var1_2;
                if (this.this$0.orderedNodeConnections == null) {
                    final Iterator entries = this.this$0.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected N computeNext() {
                            while (entries.hasNext()) {
                                void var1_1;
                                Map.Entry entry = (Map.Entry)entries.next();
                                if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                                return var1_1.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                Iterator nodeConnections = this.this$0.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this, (Iterator)var1_2){
                    final /* synthetic */ Iterator val$nodeConnections;
                    {
                        this.val$nodeConnections = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected N computeNext() {
                        while (this.val$nodeConnections.hasNext()) {
                            void var1_1;
                            NodeConnection nodeConnection = (NodeConnection)this.val$nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Pred)) continue;
                            return var1_1.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.predecessorCount;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                return DirectedGraphConnections.isPredecessor(this.this$0.adjacentNodeValues.get(var1_1));
            }
        };
    }

    @Override
    public final Set<N> successors() {
        return new AbstractSet<N>(this){
            final /* synthetic */ DirectedGraphConnections this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public UnmodifiableIterator<N> iterator() {
                void var1_2;
                if (this.this$0.orderedNodeConnections == null) {
                    final Iterator entries = this.this$0.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected N computeNext() {
                            while (entries.hasNext()) {
                                void var1_1;
                                Map.Entry entry = (Map.Entry)entries.next();
                                if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                                return var1_1.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                Iterator nodeConnections = this.this$0.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this, (Iterator)var1_2){
                    final /* synthetic */ Iterator val$nodeConnections;
                    {
                        this.val$nodeConnections = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected N computeNext() {
                        while (this.val$nodeConnections.hasNext()) {
                            void var1_1;
                            NodeConnection nodeConnection = (NodeConnection)this.val$nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Succ)) continue;
                            return var1_1.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.successorCount;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                return DirectedGraphConnections.isSuccessor(this.this$0.adjacentNodeValues.get(var1_1));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<EndpointPair<N>> incidentEdgeIterator(N thisNode) {
        void var2_2;
        void var1_1;
        Iterator resultWithDoubleSelfLoop;
        Preconditions.checkNotNull(thisNode);
        resultWithDoubleSelfLoop = this.orderedNodeConnections == null ? Iterators.concat(Iterators.transform(this.predecessors().iterator(), predecessor -> {
            Object object;
            return EndpointPair.ordered(predecessor, object);
        }), Iterators.transform(this.successors().iterator(), successor -> {
            void var1_1;
            return EndpointPair.ordered(thisNode, var1_1);
        })) : Iterators.transform(this.orderedNodeConnections.iterator(), connection -> {
            Object object;
            void var1_1;
            if (connection instanceof NodeConnection.Succ) {
                return EndpointPair.ordered(resultWithDoubleSelfLoop, connection.node);
            }
            return EndpointPair.ordered(var1_1.node, object);
        });
        AtomicBoolean alreadySeenSelfLoop = new AtomicBoolean(false);
        return new AbstractIterator<EndpointPair<N>>(this, (Iterator)var1_1, (AtomicBoolean)var2_2){
            final /* synthetic */ Iterator val$resultWithDoubleSelfLoop;
            final /* synthetic */ AtomicBoolean val$alreadySeenSelfLoop;
            {
                this.val$resultWithDoubleSelfLoop = iterator;
                this.val$alreadySeenSelfLoop = atomicBoolean;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected EndpointPair<N> computeNext() {
                while (this.val$resultWithDoubleSelfLoop.hasNext()) {
                    void var1_1;
                    EndpointPair edge = (EndpointPair)this.val$resultWithDoubleSelfLoop.next();
                    if (edge.nodeU().equals(edge.nodeV())) {
                        if (this.val$alreadySeenSelfLoop.getAndSet(true)) continue;
                        return edge;
                    }
                    return var1_1;
                }
                return (EndpointPair)this.endOfData();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V value(N node) {
        void var1_1;
        Preconditions.checkNotNull(node);
        Object value = this.adjacentNodeValues.get(node);
        if (value == PRED) {
            return null;
        }
        if (value instanceof PredAndSucc) {
            return (V)((PredAndSucc)value).successorValue;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removePredecessor(N node) {
        void var2_3;
        void removedPredecessor;
        boolean removedPredecessor2;
        Preconditions.checkNotNull(node);
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == PRED) {
            this.adjacentNodeValues.remove(node);
            removedPredecessor2 = true;
        } else if (removedPredecessor instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, ((PredAndSucc)removedPredecessor).successorValue);
            removedPredecessor2 = true;
        } else {
            removedPredecessor2 = false;
        }
        if (var2_3 != false) {
            Graphs.checkNonNegative(--this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                void var1_1;
                this.orderedNodeConnections.remove(new NodeConnection.Pred<void>(var1_1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V removeSuccessor(Object node) {
        void var2_2;
        Object removedValue;
        Preconditions.checkNotNull(node);
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == null || previousValue == PRED) {
            removedValue = null;
        } else if (removedValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, PRED);
            removedValue = ((PredAndSucc)removedValue).successorValue;
        } else {
            this.adjacentNodeValues.remove(node);
        }
        if (removedValue != null) {
            Graphs.checkNonNegative(--this.successorCount);
            if (this.orderedNodeConnections != null) {
                void var1_1;
                this.orderedNodeConnections.remove(new NodeConnection.Succ<void>(var1_1));
            }
        }
        if (removedValue == null) {
            return null;
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void addPredecessor(N node, V unused) {
        block5: {
            block6: {
                block4: {
                    previousValue = this.adjacentNodeValues.put(node, DirectedGraphConnections.PRED);
                    if (previousValue != null) break block4;
                    addedPredecessor = true;
                    break block5;
                }
                if (!(addedPredecessor instanceof PredAndSucc)) break block6;
                this.adjacentNodeValues.put(node, addedPredecessor);
                ** GOTO lbl-1000
            }
            if (addedPredecessor != DirectedGraphConnections.PRED) {
                this.adjacentNodeValues.put(node, new PredAndSucc(addedPredecessor));
                addedPredecessor = true;
            } else lbl-1000:
            // 2 sources

            {
                addedPredecessor = false;
            }
        }
        if (var2_3 != false) {
            Graphs.checkPositive(++this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Pred<void>(var1_1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V addSuccessor(N node, V value) {
        void var2_2;
        Object previousSuccessor;
        Object previousValue = this.adjacentNodeValues.put(node, value);
        if (previousValue == null) {
            previousSuccessor = null;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, new PredAndSucc(previousSuccessor));
            previousSuccessor = ((PredAndSucc)previousValue).successorValue;
        } else if (previousValue == PRED) {
            this.adjacentNodeValues.put(node, new PredAndSucc(previousSuccessor));
            previousSuccessor = null;
        } else {
            void var3_3;
            previousSuccessor = var3_3;
        }
        if (previousSuccessor == null) {
            Graphs.checkPositive(++this.successorCount);
            if (this.orderedNodeConnections != null) {
                void var1_1;
                this.orderedNodeConnections.add(new NodeConnection.Succ<void>(var1_1));
            }
        }
        if (previousSuccessor == null) {
            return null;
        }
        return var2_2;
    }

    private static boolean isPredecessor(Object value) {
        Object object;
        return value == PRED || object instanceof PredAndSucc;
    }

    private static boolean isSuccessor(Object value) {
        Object object;
        return value != PRED && object != null;
    }

    private static abstract class NodeConnection<N> {
        final N node;

        /*
         * WARNING - void declaration
         */
        NodeConnection(N node) {
            void var1_1;
            this.node = Preconditions.checkNotNull(var1_1);
        }

        static final class Succ<N>
        extends NodeConnection<N> {
            /*
             * WARNING - void declaration
             */
            Succ(N node) {
                super(var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean equals(Object that) {
                if (that instanceof Succ) {
                    void var1_1;
                    return this.node.equals(((Succ)var1_1).node);
                }
                return false;
            }

            public final int hashCode() {
                return Succ.class.hashCode() + this.node.hashCode();
            }
        }

        static final class Pred<N>
        extends NodeConnection<N> {
            /*
             * WARNING - void declaration
             */
            Pred(N node) {
                super(var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean equals(Object that) {
                if (that instanceof Pred) {
                    void var1_1;
                    return this.node.equals(((Pred)var1_1).node);
                }
                return false;
            }

            public final int hashCode() {
                return Pred.class.hashCode() + this.node.hashCode();
            }
        }
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        /*
         * WARNING - void declaration
         */
        PredAndSucc(Object successorValue) {
            void var1_1;
            this.successorValue = var1_1;
        }
    }
}

