/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.graph.AbstractBaseGraph;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.ValueGraph;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class AbstractValueGraph<N, V>
extends AbstractBaseGraph<N>
implements ValueGraph<N, V> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(this){
            final /* synthetic */ AbstractValueGraph this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Set<N> nodes() {
                return this.this$0.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                return this.this$0.edges();
            }

            @Override
            public boolean isDirected() {
                return this.this$0.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return this.this$0.allowsSelfLoops();
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return this.this$0.nodeOrder();
            }

            @Override
            public ElementOrder<N> incidentEdgeOrder() {
                return this.this$0.incidentEdgeOrder();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> adjacentNodes(N node) {
                void var1_1;
                return this.this$0.adjacentNodes(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> predecessors(N node) {
                void var1_1;
                return this.this$0.predecessors((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> successors(N node) {
                void var1_1;
                return this.this$0.successors((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int degree(N node) {
                void var1_1;
                return this.this$0.degree((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int inDegree(N node) {
                void var1_1;
                return this.this$0.inDegree((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int outDegree(N node) {
                void var1_1;
                return this.this$0.outDegree((Object)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<V> edgeValue(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        return Optional.ofNullable(this.edgeValueOrDefault(var1_1, var2_2, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<V> edgeValue(EndpointPair<N> endpoints) {
        void var1_1;
        return Optional.ofNullable(this.edgeValueOrDefault(var1_1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueGraph)) {
            return false;
        }
        ValueGraph other = (ValueGraph)obj;
        return this.isDirected() == other.isDirected() && this.nodes().equals(other.nodes()) && AbstractValueGraph.edgeValueMap(this).equals(AbstractValueGraph.edgeValueMap(var1_1));
    }

    @Override
    public final int hashCode() {
        return AbstractValueGraph.edgeValueMap(this).hashCode();
    }

    public String toString() {
        boolean bl = this.isDirected();
        boolean bl2 = this.allowsSelfLoops();
        String string = String.valueOf(this.nodes());
        String string2 = String.valueOf(AbstractValueGraph.edgeValueMap(this));
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("isDirected: ").append(bl).append(", allowsSelfLoops: ").append(bl2).append(", nodes: ").append(string).append(", edges: ").append(string2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <N, V> Map<EndpointPair<N>, V> edgeValueMap(final ValueGraph<N, V> graph) {
        void var1_1;
        ValueGraph<N, V> valueGraph;
        Function edgeToValueFn = new Function<EndpointPair<N>, V>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public V apply(EndpointPair<N> edge) {
                void var1_1;
                return Objects.requireNonNull(graph.edgeValueOrDefault(edge.nodeU(), var1_1.nodeV(), null));
            }
        };
        return Maps.asMap(valueGraph.edges(), var1_1);
    }
}

