/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.NetworkConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class AbstractUndirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    final Map<E, N> incidentEdgeMap;

    /*
     * WARNING - void declaration
     */
    AbstractUndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        void var1_1;
        this.incidentEdgeMap = (Map)Preconditions.checkNotNull(var1_1);
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<E> incidentEdges() {
        return Collections.unmodifiableSet(this.incidentEdgeMap.keySet());
    }

    @Override
    public Set<E> inEdges() {
        return this.incidentEdges();
    }

    @Override
    public Set<E> outEdges() {
        return this.incidentEdges();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public N adjacentNode(E edge) {
        void var1_1;
        return Objects.requireNonNull(this.incidentEdgeMap.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public N removeInEdge(E edge, boolean isSelfLoop) {
        if (!isSelfLoop) {
            void var1_1;
            return this.removeOutEdge(var1_1);
        }
        return null;
    }

    @Override
    public N removeOutEdge(E edge) {
        N n;
        n = this.incidentEdgeMap.remove(n);
        return Objects.requireNonNull(n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addInEdge(E edge, N node, boolean isSelfLoop) {
        if (!isSelfLoop) {
            void var2_2;
            void var1_1;
            this.addOutEdge(var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addOutEdge(E edge, N node) {
        void var2_2;
        void var1_1;
        Preconditions.checkState((var1_1 = this.incidentEdgeMap.put(var1_1, var2_2)) == null);
    }
}

