/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(this){
            final /* synthetic */ AbstractNetwork this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Set<N> nodes() {
                return this.this$0.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (this.this$0.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(this.this$1.this$0.edges().iterator(), new Function<E, EndpointPair<N>>(this){
                            final /* synthetic */ 1 this$2;
                            {
                                void var1_1;
                                this.this$2 = var1_1;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public EndpointPair<N> apply(E edge) {
                                void var1_1;
                                return this.this$2.this$1.this$0.incidentNodes(var1_1);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return this.this$1.this$0.edges().size();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean contains(Object obj) {
                        void var1_1;
                        if (!(obj instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)obj;
                        return this.this$1.isOrderingCompatible(endpointPair) && this.this$1.nodes().contains(endpointPair.nodeU()) && this.this$1.successors(endpointPair.nodeU()).contains(var1_1.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return this.this$0.nodeOrder();
            }

            @Override
            public ElementOrder<N> incidentEdgeOrder() {
                return ElementOrder.unordered();
            }

            @Override
            public boolean isDirected() {
                return this.this$0.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return this.this$0.allowsSelfLoops();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> adjacentNodes(N node) {
                void var1_1;
                return this.this$0.adjacentNodes(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> predecessors(N node) {
                void var1_1;
                return this.this$0.predecessors((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Set<N> successors(N node) {
                void var1_1;
                return this.this$0.successors((Object)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int degree(N node) {
        void var1_1;
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(node).size(), this.outEdges(node).size());
        }
        void v0 = var1_1;
        return IntMath.saturatedAdd(this.incidentEdges(node).size(), this.edgesConnecting(v0, v0).size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int inDegree(N node) {
        void var1_1;
        if (this.isDirected()) {
            return this.inEdges(node).size();
        }
        return this.degree(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int outDegree(N node) {
        void var1_1;
        if (this.isDirected()) {
            return this.outEdges(node).size();
        }
        return this.degree(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> adjacentEdges(E edge) {
        void var1_1;
        Sets.SetView setView;
        EndpointPair endpointPair = this.incidentNodes(edge);
        setView = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(((EndpointPair)((Object)setView)).nodeV()));
        return Sets.difference(setView, ImmutableSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        void var1_1;
        void var2_2;
        Set outEdgesU = this.outEdges(nodeU);
        Set inEdgesV = this.inEdges(nodeV);
        if (outEdgesU.size() <= inEdgesV.size()) {
            void var3_3;
            return Collections.unmodifiableSet(Sets.filter(var3_3, this.connectedPredicate(nodeU, nodeV)));
        }
        return Collections.unmodifiableSet(Sets.filter(inEdgesV, this.connectedPredicate(var2_2, var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.edgesConnecting(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    private Predicate<E> connectedPredicate(N nodePresent, N nodeToCheck) {
        void var2_2;
        void var1_1;
        return new Predicate<E>(this, var1_1, var2_2){
            final /* synthetic */ Object val$nodePresent;
            final /* synthetic */ Object val$nodeToCheck;
            final /* synthetic */ AbstractNetwork this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$nodePresent = object;
                this.val$nodeToCheck = object2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean apply(E edge) {
                void var1_1;
                return this.this$0.incidentNodes(var1_1).adjacentNode(this.val$nodePresent).equals(this.val$nodeToCheck);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<E> edgeConnecting(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        return Optional.ofNullable(this.edgeConnectingOrNull(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.edgeConnecting(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E edgeConnectingOrNull(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        Set<E> edgesConnecting = this.edgesConnecting(nodeU, nodeV);
        switch (edgesConnecting.size()) {
            case 0: {
                return null;
            }
            case 1: {
                void var3_3;
                return var3_3.iterator().next();
            }
        }
        throw new IllegalArgumentException(String.format("Cannot call edgeConnecting() when parallel edges exist between %s and %s. Consider calling edgesConnecting() instead.", var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
        void var1_1;
        this.validateEndpoints(endpoints);
        return this.edgeConnectingOrNull(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(nodeU);
        Preconditions.checkNotNull(nodeV);
        return this.nodes().contains(nodeU) && this.successors((Object)var1_1).contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        void var1_1;
        Preconditions.checkNotNull(endpoints);
        if (!this.isOrderingCompatible(endpoints)) {
            return false;
        }
        return this.hasEdgeConnecting(endpoints.nodeU(), var1_1.nodeV());
    }

    /*
     * WARNING - void declaration
     */
    protected final void validateEndpoints(EndpointPair<?> endpoints) {
        void var1_1;
        Preconditions.checkNotNull(endpoints);
        Preconditions.checkArgument(this.isOrderingCompatible((EndpointPair<?>)var1_1), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpoints) {
        return endpoints.isOrdered() || !this.isDirected();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return this.isDirected() == other.isDirected() && this.nodes().equals(other.nodes()) && AbstractNetwork.edgeIncidentNodesMap(this).equals(AbstractNetwork.edgeIncidentNodesMap(var1_1));
    }

    @Override
    public final int hashCode() {
        return AbstractNetwork.edgeIncidentNodesMap(this).hashCode();
    }

    public String toString() {
        boolean bl = this.isDirected();
        boolean bl2 = this.allowsParallelEdges();
        boolean bl3 = this.allowsSelfLoops();
        String string = String.valueOf(this.nodes());
        String string2 = String.valueOf(AbstractNetwork.edgeIncidentNodesMap(this));
        return new StringBuilder(87 + String.valueOf(string).length() + String.valueOf(string2).length()).append("isDirected: ").append(bl).append(", allowsParallelEdges: ").append(bl2).append(", allowsSelfLoops: ").append(bl3).append(", nodes: ").append(string).append(", edges: ").append(string2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <N, E> Map<E, EndpointPair<N>> edgeIncidentNodesMap(final Network<N, E> network) {
        void var1_1;
        Network<N, E> network2;
        Function edgeToIncidentNodesFn = new Function<E, EndpointPair<N>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public EndpointPair<N> apply(E edge) {
                void var1_1;
                return network.incidentNodes(var1_1);
            }
        };
        return Maps.asMap(network2.edges(), var1_1);
    }
}

